/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.assertj.db.type.AbstractConnectionProvider;
import org.assertj.db.type.SchemaMetadata;
import org.assertj.db.type.lettercase.LetterCase;

public class JdbcUrlConnectionProvider
extends AbstractConnectionProvider {
    private final String url;
    private final String user;
    private final String password;

    JdbcUrlConnectionProvider(String url, String user, String password, Class<? extends SchemaMetadata> schemaMetadataType, LetterCase tableLetterCase, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        super(schemaMetadataType, tableLetterCase, columnLetterCase, primaryKeyLetterCase);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    public String toString() {
        return this.user + "/" + this.url;
    }
}

