/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.util.ArrayList;
import java.util.List;
import org.assertj.db.type.DbElement;
import org.assertj.db.type.Value;
import org.assertj.db.type.lettercase.LetterCase;
import org.assertj.db.type.lettercase.WithColumnLetterCase;
import org.assertj.db.type.lettercase.WithPrimaryKeyLetterCase;
import org.assertj.db.util.NameComparator;
import org.assertj.db.util.Values;

public class Row
implements DbElement,
WithColumnLetterCase,
WithPrimaryKeyLetterCase {
    private final List<String> columnsNameList;
    private final List<Value> valuesList;
    private final LetterCase columnLetterCase;
    private final LetterCase primaryKeyLetterCase;
    private List<String> pksNameList;

    Row(List<String> pksNameList, List<String> columnsNameList, List<Value> valuesList, LetterCase columnLetterCase, LetterCase primaryKeyLetterCase) {
        this.pksNameList = pksNameList;
        this.columnsNameList = columnsNameList;
        this.valuesList = valuesList;
        this.columnLetterCase = columnLetterCase;
        this.primaryKeyLetterCase = primaryKeyLetterCase;
    }

    @Override
    public LetterCase getColumnLetterCase() {
        return this.columnLetterCase;
    }

    @Override
    public LetterCase getPrimaryKeyLetterCase() {
        return this.primaryKeyLetterCase;
    }

    public List<String> getPksNameList() {
        return this.pksNameList;
    }

    void setPksNameList(List<String> pksNameList) {
        this.pksNameList = pksNameList;
    }

    public List<Value> getPksValueList() {
        ArrayList<Value> pksValueList = new ArrayList<Value>();
        if (this.pksNameList != null) {
            for (String name : this.pksNameList) {
                int index = NameComparator.INSTANCE.indexOf(this.columnsNameList, name, this.primaryKeyLetterCase);
                Value value = this.valuesList.get(index);
                pksValueList.add(value);
            }
        }
        return pksValueList;
    }

    public List<String> getColumnsNameList() {
        return this.columnsNameList;
    }

    public List<Value> getValuesList() {
        return this.valuesList;
    }

    public Value[] getPksValues() {
        ArrayList<Value> pksValuesList = new ArrayList<Value>();
        if (this.pksNameList != null) {
            for (String pkName : this.pksNameList) {
                int index = NameComparator.INSTANCE.indexOf(this.columnsNameList, pkName, this.primaryKeyLetterCase);
                Value value = this.valuesList.get(index);
                pksValuesList.add(value);
            }
        }
        return pksValuesList.toArray(new Value[0]);
    }

    public boolean hasPksValuesEqualTo(Value[] pksValues) {
        Value[] pksValues1 = this.getPksValues();
        if (pksValues1.length != 0 && pksValues1.length == pksValues.length) {
            for (int index = 0; index < pksValues1.length; ++index) {
                if (Values.areEqual(pksValues1[index], pksValues[index].getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasValues(Row row) {
        List<Value> currentValuesList = this.getValuesList();
        List<Value> rowValuesList = row.getValuesList();
        for (int index = 0; index < currentValuesList.size(); ++index) {
            Value rowValue;
            Value value = currentValuesList.get(index);
            if (Values.areEqual(value, (rowValue = rowValuesList.get(index)).getValue())) continue;
            return false;
        }
        return true;
    }

    public Value getColumnValue(int index) {
        return this.valuesList.get(index);
    }

    public Value getColumnValue(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("Column name must be not null");
        }
        int index = NameComparator.INSTANCE.indexOf(this.columnsNameList, columnName, this.columnLetterCase);
        if (index == -1) {
            return null;
        }
        return this.getColumnValue(index);
    }
}

