/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.jodatime.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.jodatime.error.ShouldBeAfter;
import org.assertj.jodatime.error.ShouldBeAfterOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeBefore;
import org.assertj.jodatime.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringHours;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMillis;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringSeconds;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateTimeAssert
extends AbstractAssert<DateTimeAssert, DateTime> {
    public static final String NULL_DATE_TIME_PARAMETER_MESSAGE = "The DateTime to compare actual with should not be null";

    protected DateTimeAssert(Class<DateTimeAssert> selfType, DateTime actual) {
        super((Object)actual, selfType);
    }

    protected DateTime getActual() {
        return (DateTime)this.actual;
    }

    public DateTimeAssert isBefore(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((DateTime)this.actual).isBefore((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isBefore(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBefore(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isBeforeOrEqualTo(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((DateTime)this.actual).isAfter((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isBeforeOrEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBeforeOrEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isAfterOrEqualTo(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((DateTime)this.actual).isBefore((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isAfterOrEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfterOrEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isAfter(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((DateTime)this.actual).isAfter((ReadableInstant)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isAfter(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfter(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isEqualToIgnoringMillis(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringMillis((DateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMillis.shouldBeEqualIgnoringMillis(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringSeconds(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringSeconds((DateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringMinutes(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.areEqualIgnoringMinutes((DateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualToIgnoringHours(DateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        DateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!DateTimeAssert.haveSameYearMonthAndDayOfMonth((DateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return this;
    }

    public DateTimeAssert isEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (DateTimeAssert)this.isEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isNotEqualTo(String dateTimeAsString) {
        DateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (DateTimeAssert)this.isNotEqualTo(new DateTime((Object)dateTimeAsString, ((DateTime)this.actual).getZone()));
    }

    public DateTimeAssert isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (DateTimeAssert)this.isIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public DateTimeAssert isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (DateTimeAssert)this.isNotIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    private DateTime[] convertToDateTimeArray(String ... dateTimesAsString) {
        DateTime[] dates = new DateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = new DateTime((Object)dateTimesAsString[i], ((DateTime)this.actual).getZone());
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given DateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given DateTime array should not be empty");
        }
    }

    private static void assertDateTimeParameterIsNotNull(DateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException(NULL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }

    private static void assertDateTimeAsStringParameterIsNotNull(String dateTimeAsString) {
        if (dateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the DateTime to compare actual with should not be null");
        }
    }

    private static boolean areEqualIgnoringMillis(DateTime actual, DateTime other) {
        return DateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecondOfMinute() == other.getSecondOfMinute();
    }

    private static boolean areEqualIgnoringSeconds(DateTime actual, DateTime other) {
        return DateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinuteOfHour() == other.getMinuteOfHour();
    }

    private static boolean areEqualIgnoringMinutes(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHourOfDay() == other.getHourOfDay();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(DateTime actual, DateTime other) {
        return DateTimeAssert.haveSameYear(actual, other) && actual.getMonthOfYear() == other.getMonthOfYear();
    }

    private static boolean haveSameYear(DateTime actual, DateTime other) {
        return actual.getYear() == other.getYear();
    }
}

