/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.jodatime.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.jodatime.error.ShouldBeAfter;
import org.assertj.jodatime.error.ShouldBeAfterOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeBefore;
import org.assertj.jodatime.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringHours;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMillis;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.jodatime.error.ShouldBeEqualIgnoringSeconds;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class LocalDateTimeAssert
extends AbstractAssert<LocalDateTimeAssert, LocalDateTime> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDateTime to compare actual with should not be null";

    protected LocalDateTimeAssert(Class<LocalDateTimeAssert> selfType, LocalDateTime actual) {
        super((Object)actual, selfType);
    }

    protected LocalDateTime getActual() {
        return (LocalDateTime)this.actual;
    }

    public LocalDateTimeAssert isBefore(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isBefore((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isBefore(String localDateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBefore(new LocalDateTime((Object)localDateTimeAsString));
    }

    public LocalDateTimeAssert isBeforeOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isAfter((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isBeforeOrEqualTo(String localDateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBeforeOrEqualTo(new LocalDateTime((Object)localDateTimeAsString));
    }

    public LocalDateTimeAssert isAfterOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isBefore((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isAfterOrEqualTo(String localDateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfterOrEqualTo(new LocalDateTime((Object)localDateTimeAsString));
    }

    public LocalDateTimeAssert isAfter(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isAfter((ReadablePartial)other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isAfter(String localDateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfter(new LocalDateTime((Object)localDateTimeAsString));
    }

    public LocalDateTimeAssert isEqualTo(String dateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (LocalDateTimeAssert)this.isEqualTo(new LocalDateTime((Object)dateTimeAsString));
    }

    public LocalDateTimeAssert isNotEqualTo(String dateTimeAsString) {
        LocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (LocalDateTimeAssert)this.isNotEqualTo(new LocalDateTime((Object)dateTimeAsString));
    }

    public LocalDateTimeAssert isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (LocalDateTimeAssert)this.isIn(LocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString));
    }

    public LocalDateTimeAssert isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (LocalDateTimeAssert)this.isNotIn(LocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString));
    }

    private static LocalDateTime[] convertToLocalDateTimeArray(String ... dateTimesAsString) {
        LocalDateTime[] dates = new LocalDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = new LocalDateTime((Object)dateTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given LocalDateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given LocalDateTime array should not be empty");
        }
    }

    private static void assertLocalDateTimeAsStringParameterIsNotNull(String localDateTimeAsString) {
        if (localDateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the LocalDateTime to compare actual with should not be null");
        }
    }

    private static void assertLocalDateTimeParameterIsNotNull(LocalDateTime other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }

    public LocalDateTimeAssert isEqualToIgnoringMillis(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!LocalDateTimeAssert.areEqualIgnoringMillis((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMillis.shouldBeEqualIgnoringMillis(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isEqualToIgnoringSeconds(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!LocalDateTimeAssert.areEqualIgnoringSeconds((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isEqualToIgnoringMinutes(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!LocalDateTimeAssert.areEqualIgnoringMinutes((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return this;
    }

    public LocalDateTimeAssert isEqualToIgnoringHours(LocalDateTime other) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        LocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!LocalDateTimeAssert.haveSameYearMonthAndDayOfMonth((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return this;
    }

    private static boolean areEqualIgnoringMillis(LocalDateTime actual, LocalDateTime other) {
        return LocalDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecondOfMinute() == other.getSecondOfMinute();
    }

    private static boolean areEqualIgnoringSeconds(LocalDateTime actual, LocalDateTime other) {
        return LocalDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinuteOfHour() == other.getMinuteOfHour();
    }

    private static boolean areEqualIgnoringMinutes(LocalDateTime actual, LocalDateTime other) {
        return LocalDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHourOfDay() == other.getHourOfDay();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(LocalDateTime actual, LocalDateTime other) {
        return LocalDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(LocalDateTime actual, LocalDateTime other) {
        return LocalDateTimeAssert.haveSameYear(actual, other) && actual.getMonthOfYear() == other.getMonthOfYear();
    }

    private static boolean haveSameYear(LocalDateTime actual, LocalDateTime other) {
        return actual.getYear() == other.getYear();
    }
}

