/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.neo4j.api;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.neo4j.api.PropertyContainerAssert;
import org.assertj.neo4j.error.ShouldHaveLabel;
import org.assertj.neo4j.error.ShouldNotHaveLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;

public class NodeAssert
extends PropertyContainerAssert<NodeAssert, Node> {
    protected NodeAssert(Node actual) {
        super(actual, NodeAssert.class);
    }

    @Override
    public Node getActual() {
        return (Node)this.actual;
    }

    public NodeAssert hasLabel(String labelValue) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (labelValue == null) {
            throw new IllegalArgumentException("The label value to look for should not be null");
        }
        if (!this.hasFoundLabel(labelValue)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveLabel.shouldHaveLabel((Node)this.actual, labelValue));
        }
        return this;
    }

    public NodeAssert doesNotHaveLabel(String labelValue) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (labelValue == null) {
            throw new IllegalArgumentException("The label value to look for should not be null");
        }
        if (this.hasFoundLabel(labelValue)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHaveLabel.shouldNotHaveLabel((Node)this.actual, labelValue));
        }
        return this;
    }

    public NodeAssert hasLabel(Label label) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (label == null) {
            throw new IllegalArgumentException("The label to look for should not be null");
        }
        if (!((Node)this.actual).hasLabel(label)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveLabel.shouldHaveLabel((Node)this.actual, label.name()));
        }
        return this;
    }

    public NodeAssert doesNotHaveLabel(Label label) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (label == null) {
            throw new IllegalArgumentException("The label to look for should not be null");
        }
        if (((Node)this.actual).hasLabel(label)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHaveLabel.shouldNotHaveLabel((Node)this.actual, label.name()));
        }
        return this;
    }

    private boolean hasFoundLabel(String labelValue) {
        try (Transaction tx = ((Node)this.actual).getGraphDatabase().beginTx();){
            for (Label label : ((Node)this.actual).getLabels()) {
                if (!labelValue.equals(label.name())) continue;
                boolean bl = true;
                return bl;
            }
            tx.success();
        }
        return false;
    }
}

