/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.neo4j.api;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.neo4j.error.ShouldEndWithNode;
import org.assertj.neo4j.error.ShouldEndWithRelationship;
import org.assertj.neo4j.error.ShouldHaveLength;
import org.assertj.neo4j.error.ShouldNotEndWithNode;
import org.assertj.neo4j.error.ShouldNotEndWithRelationship;
import org.assertj.neo4j.error.ShouldNotStartWithNode;
import org.assertj.neo4j.error.ShouldStartWithNode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

public class PathAssert
extends IterableAssert<PropertyContainer> {
    protected PathAssert(Path actual) {
        super((Iterable)actual);
    }

    public Path getActual() {
        return (Path)this.actual;
    }

    public PathAssert startsWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Node actualStart = actualPath.startNode();
        PathAssert.checkNullStartNodes(actualStart, node);
        if (!actualStart.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldStartWithNode.shouldStartWithNode(actualPath, node));
        }
        return this;
    }

    public PathAssert doesNotStartWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Node actualStart = actualPath.startNode();
        PathAssert.checkNullStartNodes(actualStart, node);
        if (actualStart.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotStartWithNode.shouldNotStartWithNode(actualPath, node));
        }
        return this;
    }

    public PathAssert endsWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Node actualEnd = actualPath.endNode();
        PathAssert.checkNullEndNodes(actualEnd, node);
        if (!actualEnd.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldEndWithNode.shouldEndWithNode(actualPath, node));
        }
        return this;
    }

    public PathAssert doesNotEndWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Node actualEnd = actualPath.endNode();
        PathAssert.checkNullEndNodes(actualEnd, node);
        if (actualEnd.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotEndWithNode.shouldNotEndWithNode(actualPath, node));
        }
        return this;
    }

    public PathAssert endsWithRelationship(Relationship relationship) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Relationship actualLastRelationship = actualPath.lastRelationship();
        PathAssert.checkNullEndRelationships(actualLastRelationship, relationship);
        if (!actualLastRelationship.equals(relationship)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldEndWithRelationship.shouldEndWithRelationship(actualPath, relationship));
        }
        return this;
    }

    public PathAssert doesNotEndWithRelationship(Relationship relationship) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Path actualPath = this.getActual();
        Relationship actualLastRelationship = actualPath.lastRelationship();
        PathAssert.checkNullEndRelationships(actualLastRelationship, relationship);
        if (actualLastRelationship.equals(relationship)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotEndWithRelationship.shouldNotEndWithRelationship(actualPath, relationship));
        }
        return this;
    }

    public PathAssert hasLength(int length) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (length < 0) {
            throw new IllegalArgumentException("The path length to compare against should be positive.");
        }
        Path actualPath = this.getActual();
        if (actualPath.length() != length) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveLength.shouldHaveLength(actualPath, length));
        }
        return this;
    }

    private static void checkNullStartNodes(Node actualStart, Node expectedStart) {
        if (actualStart == null) {
            throw new IllegalStateException("The actual start node should not be null");
        }
        if (expectedStart == null) {
            throw new IllegalArgumentException("The start node to look for should not be null");
        }
    }

    private static void checkNullEndNodes(Node actualEnd, Node expectedEnd) {
        if (actualEnd == null) {
            throw new IllegalStateException("The actual end node should not be null");
        }
        if (expectedEnd == null) {
            throw new IllegalArgumentException("The end node to look for should not be null");
        }
    }

    private static void checkNullEndRelationships(Relationship actualEnd, Relationship expectedEnd) {
        if (actualEnd == null) {
            throw new IllegalStateException("The actual last relationship should not be null");
        }
        if (expectedEnd == null) {
            throw new IllegalArgumentException("The last relationship to look for should not be null");
        }
    }
}

