/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.neo4j.api;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.neo4j.error.ShouldHaveProperty;
import org.assertj.neo4j.error.ShouldHavePropertyKey;
import org.assertj.neo4j.error.ShouldNotHaveProperty;
import org.assertj.neo4j.error.ShouldNotHavePropertyKey;
import org.neo4j.graphdb.PropertyContainer;

public class PropertyContainerAssert<A extends PropertyContainerAssert<A, T>, T extends PropertyContainer>
extends AbstractAssert<A, T> {
    protected PropertyContainerAssert(T actual, Class<? extends A> assertClass) {
        super(actual, assertClass);
    }

    public T getActual() {
        return (T)((PropertyContainer)this.actual);
    }

    public A hasPropertyKey(String key) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        PropertyContainerAssert.checkPropertyKeyIsNotNull(key);
        if (!((PropertyContainer)this.actual).hasProperty(key)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHavePropertyKey.shouldHavePropertyKey((PropertyContainer)this.actual, key));
        }
        return (A)((Object)((PropertyContainerAssert)this.myself));
    }

    public A hasProperty(String key, Object value) {
        this.hasPropertyKey(key);
        PropertyContainerAssert.checkPropertyValueIsNotNull(value);
        if (!value.equals(((PropertyContainer)this.actual).getProperty(key, null))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveProperty.shouldHaveProperty((PropertyContainer)this.actual, key, value));
        }
        return (A)((Object)((PropertyContainerAssert)this.myself));
    }

    public A doesNotHavePropertyKey(String key) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        PropertyContainerAssert.checkPropertyKeyIsNotNull(key);
        if (((PropertyContainer)this.actual).hasProperty(key)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHavePropertyKey.shouldNotHavePropertyKey((PropertyContainer)this.actual, key));
        }
        return (A)((Object)((PropertyContainerAssert)this.myself));
    }

    public A doesNotHaveProperty(String key, Object value) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        PropertyContainerAssert.checkPropertyKeyIsNotNull(key);
        PropertyContainerAssert.checkPropertyValueIsNotNull(value);
        if (((PropertyContainer)this.actual).hasProperty(key) && value.equals(((PropertyContainer)this.actual).getProperty(key, null))) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHaveProperty.shouldNotHaveProperty((PropertyContainer)this.actual, key, value));
        }
        return (A)((Object)((PropertyContainerAssert)this.myself));
    }

    private static void checkPropertyValueIsNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("The value to look for should not be null");
        }
    }

    private static void checkPropertyKeyIsNotNull(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key to look for should not be null");
        }
    }
}

