/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.neo4j.api;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.neo4j.api.PropertyContainerAssert;
import org.assertj.neo4j.error.ShouldEndWithNode;
import org.assertj.neo4j.error.ShouldHaveRelationshipType;
import org.assertj.neo4j.error.ShouldNotEndWithNode;
import org.assertj.neo4j.error.ShouldNotHaveRelationshipType;
import org.assertj.neo4j.error.ShouldNotStartWithNode;
import org.assertj.neo4j.error.ShouldStartOrEndWithNode;
import org.assertj.neo4j.error.ShouldStartWithNode;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class RelationshipAssert
extends PropertyContainerAssert<RelationshipAssert, Relationship> {
    protected RelationshipAssert(Relationship actual) {
        super(actual, RelationshipAssert.class);
    }

    @Override
    public Relationship getActual() {
        return (Relationship)this.actual;
    }

    public RelationshipAssert startsWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Node actualStartNode = ((Relationship)this.actual).getStartNode();
        RelationshipAssert.checkActualRelationshipNode(actualStartNode, "The actual start node should not be null");
        RelationshipAssert.checkArgumentNode(node, "The start node to look for should not be null");
        if (!actualStartNode.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldStartWithNode.shouldStartWithNode((Relationship)this.actual, node));
        }
        return this;
    }

    public RelationshipAssert doesNotStartWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Node actualStartNode = ((Relationship)this.actual).getStartNode();
        RelationshipAssert.checkActualRelationshipNode(actualStartNode, "The actual start node should not be null");
        RelationshipAssert.checkArgumentNode(node, "The start node to look for should not be null");
        if (actualStartNode.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotStartWithNode.shouldNotStartWithNode((Relationship)this.actual, node));
        }
        return this;
    }

    public RelationshipAssert endsWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Node actualEndNode = ((Relationship)this.actual).getEndNode();
        RelationshipAssert.checkActualRelationshipNode(actualEndNode, "The actual end node should not be null");
        RelationshipAssert.checkArgumentNode(node, "The end node to look for should not be null");
        if (!actualEndNode.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldEndWithNode.shouldEndWithNode((Relationship)this.actual, node));
        }
        return this;
    }

    public RelationshipAssert doesNotEndWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Node actualEndNode = ((Relationship)this.actual).getEndNode();
        RelationshipAssert.checkActualRelationshipNode(actualEndNode, "The actual end node should not be null");
        RelationshipAssert.checkArgumentNode(node, "The end node to look for should not be null");
        if (actualEndNode.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotEndWithNode.shouldNotEndWithNode((Relationship)this.actual, node));
        }
        return this;
    }

    public RelationshipAssert startsOrEndsWithNode(Node node) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        Node actualStartNode = ((Relationship)this.actual).getStartNode();
        Node actualEndNode = ((Relationship)this.actual).getEndNode();
        RelationshipAssert.checkActualRelationshipNode(actualStartNode, "The actual start node should not be null");
        RelationshipAssert.checkActualRelationshipNode(actualEndNode, "The actual end node should not be null");
        RelationshipAssert.checkArgumentNode(node, "The node to look for should not be null");
        if (!actualStartNode.equals(node) && !actualEndNode.equals(node)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldStartOrEndWithNode.shouldStartOrEndWithNode((Relationship)this.actual, node));
        }
        return this;
    }

    public RelationshipAssert hasType(RelationshipType relationshipType) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        RelationshipType actualType = ((Relationship)this.actual).getType();
        RelationshipAssert.checkTypeIsNotNull(actualType);
        if (relationshipType == null) {
            throw new IllegalArgumentException("The relationship type to look for should not be null");
        }
        return this.hasType(relationshipType.name());
    }

    public RelationshipAssert hasType(String relationshipTypeName) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        RelationshipType actualType = ((Relationship)this.actual).getType();
        RelationshipAssert.checkTypeNameIsNotNull(actualType);
        if (relationshipTypeName == null) {
            throw new IllegalArgumentException("The relationship type to look for should not be null");
        }
        if (!actualType.name().equals(relationshipTypeName)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveRelationshipType.shouldHaveRelationshipType((Relationship)this.actual, relationshipTypeName));
        }
        return this;
    }

    public RelationshipAssert doesNotHaveType(RelationshipType relationshipType) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        RelationshipType actualType = ((Relationship)this.actual).getType();
        RelationshipAssert.checkTypeIsNotNull(actualType);
        if (relationshipType == null) {
            throw new IllegalArgumentException("The relationship type to look for should not be null");
        }
        return this.doesNotHaveType(relationshipType.name());
    }

    public RelationshipAssert doesNotHaveType(String relationshipTypeName) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        RelationshipType actualType = ((Relationship)this.actual).getType();
        RelationshipAssert.checkTypeNameIsNotNull(actualType);
        if (relationshipTypeName == null) {
            throw new IllegalArgumentException("The relationship type to look for should not be null");
        }
        if (actualType.name().equals(relationshipTypeName)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldNotHaveRelationshipType.shouldNotHaveRelationshipType((Relationship)this.actual, relationshipTypeName));
        }
        return this;
    }

    private static void checkActualRelationshipNode(Node node, String errorMessage) {
        if (node == null) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkArgumentNode(Node node, String errorMessage) {
        if (node == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void checkTypeNameIsNotNull(RelationshipType actualType) {
        RelationshipAssert.checkTypeIsNotNull(actualType);
        if (actualType.name() == null) {
            throw new IllegalStateException("The actual relationship type name should not be null");
        }
    }

    private static void checkTypeIsNotNull(RelationshipType actualType) {
        if (actualType == null) {
            throw new IllegalStateException("The actual relationship type should not be null");
        }
    }
}

