/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.testng.listener;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.util.Strings;
import org.testng.ITestResult;

final class ScreenshotFileNameGenerator {
    private static final String NULL_PARAMETER_VALUE = "[null]";

    static String screenshotFileNameFrom(ITestResult result) {
        String[] parts = ScreenshotFileNameGenerator.namePartsFrom(result);
        return Strings.join((String[])parts).with(".");
    }

    private static String[] namePartsFrom(ITestResult result) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(result.getTestClass().getName());
        parts.add(result.getMethod().getMethodName());
        ScreenshotFileNameGenerator.addParameters(result, parts);
        parts.add("png");
        return parts.toArray(new String[parts.size()]);
    }

    private static void addParameters(ITestResult result, List<String> parts) {
        Object[] parameters = result.getParameters();
        if (parameters == null) {
            return;
        }
        for (Object parameter : parameters) {
            parts.add(parameter != null ? parameter.toString() : NULL_PARAMETER_VALUE);
        }
    }

    private ScreenshotFileNameGenerator() {
    }
}

