/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.testng.listener;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.GUITestFinder;
import org.assertj.swing.image.ImageException;
import org.assertj.swing.image.NoopScreenshotTaker;
import org.assertj.swing.image.ScreenshotTaker;
import org.assertj.swing.image.ScreenshotTakerIF;
import org.assertj.swing.testng.listener.AbstractTestListener;
import org.assertj.swing.testng.listener.OutputDirectory;
import org.assertj.swing.testng.listener.ScreenshotFileNameGenerator;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;

public class ScreenshotOnFailureListener
extends AbstractTestListener {
    private static Logger logger = Logger.getAnonymousLogger();
    private ScreenshotTakerIF screenshotTaker;
    private OutputDirectory output;
    private boolean ready;

    public ScreenshotOnFailureListener() {
        try {
            this.screenshotTaker = GraphicsEnvironment.isHeadless() ? new NoopScreenshotTaker() : new ScreenshotTaker();
        }
        catch (ImageException e) {
            logger.log(Level.SEVERE, "Unable to create ScreenshotTaker", e);
        }
    }

    @VisibleForTesting
    String output() {
        return this.output.path();
    }

    @Override
    public void onStart(ITestContext context) {
        this.output = new OutputDirectory(context);
        logger.info(Strings.concat((Object[])new Object[]{"TestNG output directory: ", Strings.quote((String)this.output.path())}));
        this.ready = this.output.hasPath() && this.screenshotTaker != null;
    }

    @Override
    public void onTestFailure(ITestResult result) {
        if (!this.ready || !ScreenshotOnFailureListener.isGUITest(result)) {
            return;
        }
        String screenshotFileName = this.takeScreenshotAndReturnFileName(result);
        if (org.assertj.swing.util.Strings.isNullOrEmpty((String)screenshotFileName)) {
            return;
        }
        logger.info(Strings.concat((Object[])new Object[]{"Screenshot of desktop saved as: ", Strings.quote((String)screenshotFileName)}));
        Reporter.setCurrentTestResult((ITestResult)result);
        Reporter.log((String)Strings.concat((Object[])new Object[]{"<a href=\"", screenshotFileName, "\">Screenshot</a>"}));
    }

    private static boolean isGUITest(ITestResult testResult) {
        Class realClass = testResult.getTestClass().getRealClass();
        Method testMethod = testResult.getMethod().getConstructorOrMethod().getMethod();
        return GUITestFinder.isGUITest((Class)realClass, (Method)testMethod);
    }

    private String takeScreenshotAndReturnFileName(ITestResult result) {
        String imageName = ScreenshotFileNameGenerator.screenshotFileNameFrom(result);
        String imagePath = Strings.concat((Object[])new Object[]{this.output(), File.separator, imageName});
        try {
            this.output.createIfNecessary();
            this.screenshotTaker.saveDesktopAsPng(imagePath);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        return imageName;
    }
}

