/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Either;
import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.EitherShouldBeLeft;
import org.assertj.vavr.api.EitherShouldBeRight;
import org.assertj.vavr.api.EitherShouldContain;
import org.assertj.vavr.api.EitherShouldContainInstanceOf;

abstract class AbstractEitherAssert<SELF extends AbstractEitherAssert<SELF, LEFT, RIGHT>, LEFT, RIGHT>
extends AbstractAssert<SELF, Either<LEFT, RIGHT>> {
    private ComparisonStrategy eitherValueComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractEitherAssert(Either<LEFT, RIGHT> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isLeft() {
        this.assertIsLeft();
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF isRight() {
        this.assertIsRight();
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsOnRight(RIGHT expectedValue) {
        this.assertIsRight();
        if (!this.eitherValueComparisonStrategy.areEqual(((Either)this.actual).get(), expectedValue)) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContain.shouldContainOnRight((Either)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsOnLeft(LEFT expectedValue) {
        this.assertIsLeft();
        if (!this.eitherValueComparisonStrategy.areEqual(((Either)this.actual).getLeft(), expectedValue)) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContain.shouldContainOnLeft((Either)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsRightSame(RIGHT expectedValue) {
        this.assertIsRight();
        if (((Either)this.actual).get() != expectedValue) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContain.shouldContainSameOnRight((Either)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsLeftSame(LEFT expectedValue) {
        this.assertIsLeft();
        if (((Either)this.actual).getLeft() != expectedValue) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContain.shouldContainSameOnLeft((Either)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsRightInstanceOf(Class<?> clazz) {
        this.assertIsRight();
        if (!clazz.isInstance(((Either)this.actual).get())) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContainInstanceOf.shouldContainOnRightInstanceOf(this.actual, clazz));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    public SELF containsLeftInstanceOf(Class<?> clazz) {
        this.assertIsLeft();
        if (!clazz.isInstance(((Either)this.actual).getLeft())) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldContainInstanceOf.shouldContainOnLeftInstanceOf(this.actual, clazz));
        }
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingValueComparator(Comparator<?> customComparator) {
        this.eitherValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingFieldByFieldValueComparator() {
        return this.usingValueComparator((Comparator<?>)new FieldByFieldComparator());
    }

    @CheckReturnValue
    public SELF usingDefaultRightValueComparator() {
        this.eitherValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((Object)((AbstractEitherAssert)this.myself));
    }

    private void checkNotNull(Object expectedValue) {
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (String)"The expected value should not be <null>.", (Object[])new Object[0]);
    }

    private void assertIsRight() {
        this.isNotNull();
        if (((Either)this.actual).isLeft()) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldBeRight.shouldBeRight((Either)this.actual));
        }
    }

    private void assertIsLeft() {
        this.isNotNull();
        if (((Either)this.actual).isRight()) {
            this.throwAssertionError((ErrorMessageFactory)EitherShouldBeLeft.shouldBeLeft((Either)this.actual));
        }
    }
}

