/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.internal.Maps;

abstract class AbstractMapAssert<SELF extends AbstractMapAssert<SELF, ACTUAL, KEY, VALUE>, ACTUAL extends Map<KEY, VALUE>, KEY, VALUE>
extends AbstractObjectAssert<SELF, ACTUAL>
implements EnumerableAssert<SELF, Tuple2<? extends KEY, ? extends VALUE>> {
    private final Maps maps = Maps.instance();
    private ComparisonStrategy elementComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractMapAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF allSatisfy(BiConsumer<? super KEY, ? super VALUE> entryRequirements) {
        Preconditions.checkNotNull(entryRequirements, (String)"The BiConsumer<K, V> expressing the assertions requirements must not be null");
        this.isNotNull();
        ((Map)this.actual).forEach(entry -> entryRequirements.accept((Object)entry._1, (Object)entry._2));
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public void isNullOrEmpty() {
        if (this.actual != null && !((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeNullOrEmpty.shouldBeNullOrEmpty((Object)this.actual));
        }
    }

    public void isEmpty() {
        this.isNotNull();
        if (!((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        if (((Map)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF contains(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF containsAnyOf(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertContainsAnyOf((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF containsAllEntriesOf(Iterable<Tuple2<KEY, VALUE>> other) {
        Tuple2[] entries = (Tuple2[])StreamSupport.stream(other.spliterator(), false).toArray(Tuple2[]::new);
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF containsEntry(KEY key, VALUE value) {
        this.maps.assertContains((AssertionInfo)this.info, (Map)this.actual, (Tuple2[])Arrays.array((Object[])new Tuple2[]{Tuple.of(key, value)}));
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF doesNotContain(Tuple2<KEY, VALUE> ... entries) {
        this.maps.assertDoesNotContain((AssertionInfo)this.info, (Map)this.actual, entries);
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF doesNotContainEntry(KEY key, VALUE value) {
        this.maps.assertDoesNotContain((AssertionInfo)this.info, (Map)this.actual, (Tuple2[])Arrays.array((Object[])new Tuple2[]{Tuple.of(key, value)}));
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF hasSize(int expectedSize) {
        this.isNotNull();
        if (((Map)this.actual).size() != expectedSize) {
            this.throwAssertionError(ShouldHaveSize.shouldHaveSize((Object)this.actual, (int)((Map)this.actual).size(), (int)expectedSize));
        }
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF hasSameSizeAs(Iterable<?> other) {
        this.isNotNull();
        Preconditions.checkNotNull(other, (String)"The other Iterable to compare actual size with should not be null");
        long expectedSize = IterableUtil.sizeOf(other);
        if ((long)((Map)this.actual).size() != expectedSize) {
            this.throwAssertionError(ShouldHaveSameSizeAs.shouldHaveSameSizeAs((Object)this.actual, (Object)((Map)this.actual).size(), (Object)expectedSize));
        }
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF hasSameSizeAs(Object array) {
        this.isNotNull();
        org.assertj.core.internal.Arrays.assertIsArray((AssertionInfo)this.info, (Object)array);
        CommonValidations.hasSameSizeAsCheck((AssertionInfo)this.info, (Object)this.actual, (Object)array, (int)((Map)this.actual).size());
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF usingElementComparator(Comparator<? super Tuple2<? extends KEY, ? extends VALUE>> customComparator) {
        this.elementComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }

    public SELF usingDefaultElementComparator() {
        this.elementComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((Object)((AbstractMapAssert)this.myself));
    }
}

