/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Option;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.OptionShouldBeEmpty;
import org.assertj.vavr.api.OptionShouldBePresent;
import org.assertj.vavr.api.OptionShouldContain;
import org.assertj.vavr.api.OptionShouldContainInstanceOf;
import org.assertj.vavr.api.VavrAssertions;

abstract class AbstractOptionAssert<SELF extends AbstractOptionAssert<SELF, VALUE>, VALUE>
extends AbstractAssert<SELF, Option<VALUE>> {
    private Conditions conditions = Conditions.instance();
    private ComparisonStrategy optionValueComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractOptionAssert(Option<VALUE> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isDefined() {
        this.assertValueIsPresent();
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((Option)this.actual).isDefined()) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldBeEmpty.shouldBeEmpty((Option)this.actual));
        }
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF contains(VALUE expectedValue) {
        this.isNotNull();
        if (((Option)this.actual).isEmpty()) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldContain.shouldContain(expectedValue));
        }
        if (!this.optionValueComparisonStrategy.areEqual(((Option)this.actual).get(), expectedValue)) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldContain.shouldContain((Option)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF hasValueSatisfying(Consumer<VALUE> requirement) {
        this.assertValueIsPresent();
        requirement.accept(((Option)this.actual).get());
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF hasValueSatisfying(Condition<? super VALUE> condition) {
        this.assertValueIsPresent();
        this.conditions.assertIs((AssertionInfo)this.info, ((Option)this.actual).get(), condition);
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF containsInstanceOf(Class<?> clazz) {
        this.assertValueIsPresent();
        if (!clazz.isInstance(((Option)this.actual).get())) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldContainInstanceOf.shouldContainInstanceOf(this.actual, clazz));
        }
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingFieldByFieldValueComparator() {
        return this.usingValueComparator((Comparator<? super VALUE>)new FieldByFieldComparator());
    }

    @CheckReturnValue
    public SELF usingValueComparator(Comparator<? super VALUE> customComparator) {
        this.optionValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    @CheckReturnValue
    public SELF usingDefaultValueComparator() {
        this.optionValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    public SELF containsSame(VALUE expectedValue) {
        this.isNotNull();
        this.checkNotNull(expectedValue);
        if (((Option)this.actual).isEmpty()) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldContain.shouldContain(expectedValue));
        }
        if (((Option)this.actual).get() != expectedValue) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldContain.shouldContainSame((Option)this.actual, expectedValue));
        }
        return (SELF)((Object)((AbstractOptionAssert)this.myself));
    }

    @CheckReturnValue
    public <U> AbstractOptionAssert<?, U> flatMap(Function<? super VALUE, Option<U>> mapper) {
        this.isNotNull();
        return VavrAssertions.assertThat(((Option)this.actual).flatMap(mapper));
    }

    @CheckReturnValue
    public <U> AbstractOptionAssert<?, U> map(Function<? super VALUE, ? extends U> mapper) {
        this.isNotNull();
        return VavrAssertions.assertThat(((Option)this.actual).map(mapper));
    }

    private void checkNotNull(Object expectedValue) {
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (String)"The expected value should not be <null>.", (Object[])new Object[0]);
    }

    private void assertValueIsPresent() {
        this.isNotNull();
        if (((Option)this.actual).isEmpty()) {
            this.throwAssertionError((ErrorMessageFactory)OptionShouldBePresent.shouldBePresent());
        }
    }
}

