/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.collection.Seq;
import java.util.Comparator;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldBeSorted;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.SeqShouldBeAtIndex;
import org.assertj.vavr.api.SeqShouldBeSorted;
import org.assertj.vavr.api.SeqShouldHaveAtIndex;

abstract class AbstractSeqAssert<SELF extends AbstractSeqAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>, ACTUAL extends Seq<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>>
extends AbstractIterableAssert<SELF, ACTUAL, ELEMENT, ELEMENT_ASSERT>
implements IndexedObjectEnumerableAssert<SELF, ELEMENT> {
    private ComparisonStrategy seqElementComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractSeqAssert(ACTUAL elements, Class<?> selfType) {
        super(elements, selfType);
    }

    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super ELEMENT> customComparator) {
        this.seqElementComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF contains(ELEMENT value, Index index) {
        this.isNotNull();
        this.assertNotEmpty();
        this.assertIndexIsValid(index);
        Object actualElement = ((Seq)this.actual).get(index.value);
        if (!this.seqElementComparisonStrategy.areEqual(actualElement, value)) {
            this.throwAssertionError(ShouldContainAtIndex.shouldContainAtIndex((Object)this.actual, value, (Index)index, (Object)((Seq)this.actual).get(index.value)));
        }
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF doesNotContain(ELEMENT value, Index index) {
        this.isNotNull();
        this.assertNotEmpty();
        this.assertIndexIsValid(index);
        Object actualElement = ((Seq)this.actual).get(index.value);
        if (this.seqElementComparisonStrategy.areEqual(actualElement, value)) {
            this.throwAssertionError(ShouldNotContainAtIndex.shouldNotContainAtIndex((Object)this.actual, value, (Index)index));
        }
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF has(Condition<? super ELEMENT> condition, Index index) {
        this.assertConditionIsMetAtIndex(condition, index, () -> this.throwAssertionError(SeqShouldHaveAtIndex.shouldHaveAtIndex((Seq)this.actual, condition, index, ((Seq)this.actual).get(index.value))));
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF is(Condition<? super ELEMENT> condition, Index index) {
        this.assertConditionIsMetAtIndex(condition, index, () -> this.throwAssertionError(SeqShouldBeAtIndex.shouldBeAtIndex((Seq)this.actual, condition, index, ((Seq)this.actual).get(index.value))));
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF isSorted() {
        this.isNotNull();
        if (this.seqElementComparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            Comparator comparator = ((ComparatorBasedComparisonStrategy)this.seqElementComparisonStrategy).getComparator();
            this.assertIsSortedAccordingToComparator(comparator);
            return (SELF)((Object)((AbstractSeqAssert)this.myself));
        }
        try {
            Seq comparableSequence = ((Seq)this.actual).map(e -> (Comparable)e);
            if (comparableSequence.size() <= 1) {
                return (SELF)((Object)((AbstractSeqAssert)this.myself));
            }
            for (int i = 0; i < comparableSequence.size() - 1; ++i) {
                if (((Comparable)comparableSequence.get(i)).compareTo(comparableSequence.get(i + 1)) <= 0) continue;
                this.throwAssertionError(SeqShouldBeSorted.shouldBeSorted(i, (Seq<? extends Object>)((Seq)this.actual)));
            }
        }
        catch (ClassCastException e2) {
            this.throwAssertionError(SeqShouldBeSorted.shouldHaveMutuallyComparableElements(this.actual));
        }
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF isSortedAccordingTo(Comparator<? super ELEMENT> comparator) {
        this.isNotNull();
        this.assertIsSortedAccordingToComparator(comparator);
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    public SELF satisfies(Consumer<? super ELEMENT> requirements, Index index) {
        this.isNotNull();
        Preconditions.checkNotNull(requirements, (String)"The Consumer expressing the assertions requirements must not be null");
        this.assertIndexIsValid(index);
        requirements.accept(((Seq)this.actual).get(index.value));
        return (SELF)((Object)((AbstractSeqAssert)this.myself));
    }

    private void assertIsSortedAccordingToComparator(Comparator<?> comparator) {
        Preconditions.checkNotNull(comparator, (String)"The given comparator should not be null");
        try {
            if (((Seq)this.actual).size() == 0) {
                return;
            }
            Comparator<?> rawComparator = comparator;
            if (((Seq)this.actual).size() == 1) {
                rawComparator.compare(((Seq)this.actual).get(0), ((Seq)this.actual).get(0));
                return;
            }
            for (int i = 0; i < ((Seq)this.actual).size() - 1; ++i) {
                if (rawComparator.compare(((Seq)this.actual).get(i), ((Seq)this.actual).get(i + 1)) <= 0) continue;
                this.throwAssertionError(SeqShouldBeSorted.shouldBeSortedAccordingToGivenComparator(i, (Seq<? extends Object>)((Seq)this.actual), comparator));
            }
        }
        catch (ClassCastException e) {
            this.throwAssertionError(ShouldBeSorted.shouldHaveComparableElementsAccordingToGivenComparator((Object)this.actual, comparator));
        }
    }

    private void assertConditionIsMetAtIndex(Condition<? super ELEMENT> condition, Index index, Runnable errorProvider) {
        this.isNotNull();
        Preconditions.checkNotNull(condition, (String)"The condition to evaluate should not be null");
        this.assertNotEmpty();
        this.assertIndexIsValid(index);
        if (!condition.matches(((Seq)this.actual).get(index.value))) {
            errorProvider.run();
        }
    }

    private void assertIndexIsValid(Index index) {
        Preconditions.checkNotNull((Object)index, (String)"Index should not be null");
        int maximum = ((Seq)this.actual).size() - 1;
        if (index.value > maximum) {
            String errorMessage = "Index should be between <0> and <%d> (inclusive) but was:%n <%d>";
            throw new IndexOutOfBoundsException(String.format(errorMessage, maximum, index.value));
        }
    }

    private void assertNotEmpty() {
        if (((Seq)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }
}

