/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.Lazy;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.vavr.api.EitherAssert;
import org.assertj.vavr.api.LazyAssert;
import org.assertj.vavr.api.MapAssert;
import org.assertj.vavr.api.OptionAssert;
import org.assertj.vavr.api.SeqAssert;
import org.assertj.vavr.api.TryAssert;
import org.assertj.vavr.api.ValidationAssert;

@CheckReturnValue
public final class VavrAssertions {
    private VavrAssertions() {
    }

    @CheckReturnValue
    public static <LEFT, RIGHT> EitherAssert<LEFT, RIGHT> assertThat(Either<LEFT, RIGHT> actual) {
        return new EitherAssert<LEFT, RIGHT>(actual);
    }

    @CheckReturnValue
    public static <VALUE> LazyAssert<VALUE> assertThat(Lazy<VALUE> actual) {
        return new LazyAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <VALUE> OptionAssert<VALUE> assertThat(Option<VALUE> actual) {
        return new OptionAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <VALUE> TryAssert<VALUE> assertThat(Try<VALUE> actual) {
        return new TryAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <VALUE> SeqAssert<VALUE> assertThat(Seq<VALUE> actual) {
        return new SeqAssert<VALUE>(actual);
    }

    @CheckReturnValue
    public static <INVALID, VALID> ValidationAssert<INVALID, VALID> assertThat(Validation<INVALID, VALID> actual) {
        return new ValidationAssert<INVALID, VALID>(actual);
    }

    @CheckReturnValue
    public static <KEY, VALUE> MapAssert<KEY, VALUE> assertThat(Map<KEY, VALUE> actual) {
        return new MapAssert<KEY, VALUE>(actual);
    }
}

