/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Validation;
import org.assertj.core.error.BasicErrorMessageFactory;

class ValidationShouldContain
extends BasicErrorMessageFactory {
    private static final String EXPECTING_TO_CONTAIN = "%nExpecting:%n  <%s>%nto contain:%n  <%s>%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_SAME = "%nExpecting:%n  <%s>%nto contain the instance (i.e. compared with ==):%n  <%s>%nbut did not.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_INVALID = "%nExpecting:%n  <%s>%nto contain valid value:%n  <%s>%nbut was invalid.";
    private static final String EXPECTING_TO_CONTAIN_BUT_IS_VALID = "%nExpecting:%n  <%s>%nto contain invalid value:%n  <%s>%nbut was valid.";

    private ValidationShouldContain(String message, Object actual, Object expected) {
        super(message, new Object[]{actual, expected});
    }

    private ValidationShouldContain(String format, Object ... arguments) {
        super(format, arguments);
    }

    static <INVALID, VALID> ValidationShouldContain shouldContainValid(Validation<INVALID, VALID> validation, VALID expectedValue) {
        return validation.isValid() ? new ValidationShouldContain(EXPECTING_TO_CONTAIN, (Object)validation, (Object)expectedValue) : ValidationShouldContain.shouldContainButIsInvalid(validation, expectedValue);
    }

    static <INVALID, VALID> ValidationShouldContain shouldContainInvalid(Validation<INVALID, VALID> validation, INVALID expectedErrorValue) {
        return validation.isInvalid() ? new ValidationShouldContain(EXPECTING_TO_CONTAIN, (Object)validation, (Object)expectedErrorValue) : ValidationShouldContain.shouldContainButIsValid(validation, expectedErrorValue);
    }

    static <INVALID, VALID> ValidationShouldContain shouldContainValidSame(Validation<INVALID, VALID> validation, VALID expectedValue) {
        return validation.isValid() ? new ValidationShouldContain(EXPECTING_TO_CONTAIN_SAME, (Object)validation, (Object)expectedValue) : ValidationShouldContain.shouldContainButIsInvalid(validation, expectedValue);
    }

    static <INVALID, VALID> ValidationShouldContain shouldContainInvalidSame(Validation<INVALID, VALID> validation, VALID expectedErrorValue) {
        return validation.isInvalid() ? new ValidationShouldContain(EXPECTING_TO_CONTAIN_SAME, (Object)validation, (Object)expectedErrorValue) : ValidationShouldContain.shouldContainButIsValid(validation, expectedErrorValue);
    }

    static ValidationShouldContain shouldContainButIsInvalid(Validation<?, ?> validation, Object expectedValidValue) {
        return new ValidationShouldContain(EXPECTING_TO_CONTAIN_BUT_IS_INVALID, (Object)validation, expectedValidValue);
    }

    static ValidationShouldContain shouldContainButIsValid(Validation<?, ?> validation, Object expectedErrorValue) {
        return new ValidationShouldContain(EXPECTING_TO_CONTAIN_BUT_IS_VALID, (Object)validation, expectedErrorValue);
    }
}

