/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.Lazy;
import io.vavr.collection.Map;
import io.vavr.collection.Multimap;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.TypeCache;
import org.assertj.core.internal.bytebuddy.dynamic.scaffold.TypeValidation;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.MethodDelegation;
import org.assertj.core.internal.bytebuddy.implementation.auxiliary.AuxiliaryType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.SuperCall;
import org.assertj.core.internal.bytebuddy.implementation.bind.annotation.This;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatcher;
import org.assertj.core.internal.bytebuddy.matcher.ElementMatchers;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.vavr.api.AbstractVavrAssert;
import org.assertj.vavr.api.ClassLoadingStrategyFactory;
import org.assertj.vavr.api.EitherAssert;
import org.assertj.vavr.api.LazyAssert;
import org.assertj.vavr.api.MapAssert;
import org.assertj.vavr.api.MultimapAssert;
import org.assertj.vavr.api.OptionAssert;
import org.assertj.vavr.api.SeqAssert;
import org.assertj.vavr.api.SetAssert;
import org.assertj.vavr.api.TryAssert;
import org.assertj.vavr.api.ValidationAssert;

public class VavrAssumptions {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy().with(TypeValidation.DISABLED).with((AuxiliaryType.NamingStrategy)new AuxiliaryType.NamingStrategy.SuffixingRandom("Assertj$Assumptions"));
    private static final Implementation ASSUMPTION = MethodDelegation.to(AssumptionMethodInterceptor.class);
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);

    @CheckReturnValue
    public static <LEFT, RIGHT> EitherAssert<LEFT, RIGHT> assumeThat(Either<LEFT, RIGHT> actual) {
        return VavrAssumptions.asAssumption(EitherAssert.class, Either.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> LazyAssert<VALUE> assumeThat(Lazy<VALUE> actual) {
        return VavrAssumptions.asAssumption(LazyAssert.class, Lazy.class, actual);
    }

    @CheckReturnValue
    public static <K, V> MapAssert<K, V> assumeThat(Map<K, V> actual) {
        return VavrAssumptions.asAssumption(MapAssert.class, Map.class, actual);
    }

    @CheckReturnValue
    public static <K, V> MultimapAssert<K, V> assumeThat(Multimap<K, V> actual) {
        return VavrAssumptions.asAssumption(MultimapAssert.class, Multimap.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> OptionAssert<VALUE> assumeThat(Option<VALUE> actual) {
        return VavrAssumptions.asAssumption(OptionAssert.class, Option.class, actual);
    }

    @CheckReturnValue
    public static <ELEMENT> SetAssert<ELEMENT> assumeThat(Set<ELEMENT> actual) {
        return VavrAssumptions.asAssumption(SetAssert.class, Set.class, actual);
    }

    @CheckReturnValue
    public static <ELEMENT> SeqAssert<ELEMENT> assumeThat(Seq<ELEMENT> actual) {
        return VavrAssumptions.asAssumption(SeqAssert.class, Seq.class, actual);
    }

    @CheckReturnValue
    public static <VALUE> TryAssert<VALUE> assumeThat(Try<VALUE> actual) {
        return VavrAssumptions.asAssumption(TryAssert.class, Try.class, actual);
    }

    @CheckReturnValue
    public static <INVALID, VALID> ValidationAssert<INVALID, VALID> assumeThat(Validation<INVALID, VALID> actual) {
        return VavrAssumptions.asAssumption(ValidationAssert.class, Validation.class, actual);
    }

    private static <ASSERTION, ACTUAL> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<ACTUAL> actualType, Object actual) {
        return VavrAssumptions.asAssumption(assertionType, (Class[])Arrays.array((Object[])new Class[]{actualType}), Arrays.array((Object[])new Object[]{actual}));
    }

    private static <ASSERTION> ASSERTION asAssumption(Class<ASSERTION> assertionType, Class<?>[] constructorTypes, Object ... constructorParams) {
        try {
            Class<ASSERTION> type = VavrAssumptions.createAssumptionClass(assertionType);
            Constructor<ASSERTION> constructor = type.getConstructor(constructorTypes);
            return constructor.newInstance(constructorParams);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create assumption instance", e);
        }
    }

    private static <ASSERTION> Class<? extends ASSERTION> createAssumptionClass(Class<ASSERTION> assertClass) {
        TypeCache.SimpleKey cacheKey = new TypeCache.SimpleKey(assertClass, new Class[0]);
        return CACHE.findOrInsert(VavrAssumptions.class.getClassLoader(), (Object)cacheKey, () -> VavrAssumptions.generateAssumptionClass(assertClass));
    }

    private static <ASSERTION> Class<? extends ASSERTION> generateAssumptionClass(Class<ASSERTION> assertionType) {
        return BYTE_BUDDY.subclass(assertionType).method((ElementMatcher)ElementMatchers.any()).intercept(ASSUMPTION).make().load(VavrAssumptions.class.getClassLoader(), ClassLoadingStrategyFactory.classLoadingStrategy(assertionType)).getLoaded();
    }

    private static RuntimeException assumptionNotMet(AssertionError assertionError) throws ReflectiveOperationException {
        Class<?> assumptionClass = VavrAssumptions.getAssumptionClass("org.junit.AssumptionViolatedException");
        if (assumptionClass != null) {
            return VavrAssumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        assumptionClass = VavrAssumptions.getAssumptionClass("org.opentest4j.TestAbortedException");
        if (assumptionClass != null) {
            return VavrAssumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        assumptionClass = VavrAssumptions.getAssumptionClass("org.testng.SkipException");
        if (assumptionClass != null) {
            return VavrAssumptions.assumptionNotMet(assumptionClass, assertionError);
        }
        throw new IllegalStateException("Assumptions require JUnit, opentest4j or TestNG on the classpath");
    }

    private static Class<?> getAssumptionClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static RuntimeException assumptionNotMet(Class<?> exceptionClass, AssertionError e) throws ReflectiveOperationException {
        return (RuntimeException)exceptionClass.getConstructor(String.class, Throwable.class).newInstance("assumption was not met due to: " + ((Throwable)((Object)e)).getMessage(), e);
    }

    private static AbstractVavrAssert<?, ?> asAssumption(AbstractVavrAssert<?, ?> assertion) {
        Object actual = assertion.actual();
        if (assertion instanceof LazyAssert) {
            return VavrAssumptions.asAssumption(LazyAssert.class, Lazy.class, actual);
        }
        if (assertion instanceof EitherAssert) {
            return VavrAssumptions.asAssumption(EitherAssert.class, Either.class, actual);
        }
        if (assertion instanceof MapAssert) {
            return VavrAssumptions.asAssumption(MapAssert.class, Map.class, actual);
        }
        if (assertion instanceof OptionAssert) {
            return VavrAssumptions.asAssumption(OptionAssert.class, Option.class, actual);
        }
        if (assertion instanceof SeqAssert) {
            return VavrAssumptions.asAssumption(SeqAssert.class, Seq.class, actual);
        }
        if (assertion instanceof TryAssert) {
            return VavrAssumptions.asAssumption(TryAssert.class, Try.class, actual);
        }
        if (assertion instanceof ValidationAssert) {
            return VavrAssumptions.asAssumption(ValidationAssert.class, Validation.class, actual);
        }
        throw new IllegalArgumentException("Unsupported assumption creation for " + assertion.getClass());
    }

    private static final class AssumptionMethodInterceptor {
        private AssumptionMethodInterceptor() {
        }

        @RuntimeType
        public static Object intercept(@This AbstractVavrAssert<?, ?> assertion, @SuperCall Callable<Object> proxy) throws Exception {
            try {
                Object result = proxy.call();
                if (result != assertion && result instanceof AbstractVavrAssert) {
                    AbstractVavrAssert assumption = VavrAssumptions.asAssumption((AbstractVavrAssert)result);
                    return assumption.withAssertionState(assertion);
                }
                return result;
            }
            catch (AssertionError e) {
                throw VavrAssumptions.assumptionNotMet(e);
            }
        }
    }
}

