/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.control.Try;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Preconditions;
import org.assertj.vavr.api.AbstractValueAssert;
import org.assertj.vavr.api.TryShouldBeFailure;
import org.assertj.vavr.api.TryShouldBeSuccess;
import org.assertj.vavr.api.TryShouldContain;
import org.assertj.vavr.api.TryShouldContainInstanceOf;
import org.assertj.vavr.api.VavrAssertions;

abstract class AbstractTryAssert<SELF extends AbstractTryAssert<SELF, VALUE>, VALUE>
extends AbstractValueAssert<SELF, Try<VALUE>> {
    private final Conditions conditions = Conditions.instance();
    private ComparisonStrategy tryValueComparisonStrategy = StandardComparisonStrategy.instance();

    AbstractTryAssert(Try<VALUE> actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isSuccess() {
        this.assertIsSuccess();
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF isFailure() {
        this.assertIsFailure();
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF contains(VALUE expectedValue) {
        this.isNotNull();
        if (((Try)this.actual).isEmpty()) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldContain.shouldContain(expectedValue));
        }
        if (!this.tryValueComparisonStrategy.areEqual(((Try)this.actual).get(), expectedValue)) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldContain.shouldContain((Try)this.actual, expectedValue));
        }
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF hasValueSatisfying(Consumer<VALUE> requirement) {
        this.assertIsSuccess();
        requirement.accept(((Try)this.actual).get());
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF hasValueSatisfying(Condition<? super VALUE> condition) {
        this.assertIsSuccess();
        this.conditions.assertIs((AssertionInfo)this.info, ((Try)this.actual).get(), condition);
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF containsInstanceOf(Class<?> clazz) {
        this.assertIsSuccess();
        if (!clazz.isInstance(((Try)this.actual).get())) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldContainInstanceOf.shouldContainInstanceOf(this.actual, clazz));
        }
        return (SELF)((AbstractTryAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingFieldByFieldValueComparator() {
        return this.usingValueComparator((Comparator<? super VALUE>)new FieldByFieldComparator());
    }

    @CheckReturnValue
    public SELF usingValueComparator(Comparator<? super VALUE> customComparator) {
        this.tryValueComparisonStrategy = new ComparatorBasedComparisonStrategy(customComparator);
        return (SELF)((AbstractTryAssert)this.myself);
    }

    @CheckReturnValue
    public SELF usingDefaultValueComparator() {
        this.tryValueComparisonStrategy = StandardComparisonStrategy.instance();
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF containsSame(VALUE expectedValue) {
        this.isNotNull();
        if (((Try)this.actual).isEmpty()) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldContain.shouldContain(expectedValue));
        }
        if (((Try)this.actual).get() != expectedValue) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldContain.shouldContainSame((Try)this.actual, expectedValue));
        }
        return (SELF)((AbstractTryAssert)this.myself);
    }

    @CheckReturnValue
    public <U> AbstractTryAssert<?, U> flatMap(Function<? super VALUE, Try<U>> mapper) {
        this.isNotNull();
        return VavrAssertions.assertThat(((Try)this.actual).flatMap(mapper));
    }

    @CheckReturnValue
    public <U> AbstractTryAssert<?, U> map(Function<? super VALUE, ? extends U> mapper) {
        this.isNotNull();
        return VavrAssertions.assertThat(((Try)this.actual).map(mapper));
    }

    public <U extends Throwable> SELF failBecauseOf(Class<U> reason) {
        this.isNotNull();
        this.checkNotNull(reason);
        this.assertIsFailure();
        Assertions.assertThat((Throwable)((Try)this.actual).getCause()).isInstanceOf(reason);
        return (SELF)((AbstractTryAssert)this.myself);
    }

    public SELF failReasonHasMessage(String exceptionMessage) {
        this.isNotNull();
        this.checkNotNull(exceptionMessage);
        this.assertIsFailure();
        Assertions.assertThat((Throwable)((Try)this.actual).getCause()).hasMessage(exceptionMessage);
        return (SELF)((AbstractTryAssert)this.myself);
    }

    private void checkNotNull(Object expectedValue) {
        Preconditions.checkArgument((expectedValue != null ? 1 : 0) != 0, (String)"The expected value should not be <null>.", (Object[])new Object[0]);
    }

    private void assertIsSuccess() {
        this.isNotNull();
        if (((Try)this.actual).isEmpty()) {
            Throwable cause = ((Try)this.actual).getCause();
            this.throwAssertionError((ErrorMessageFactory)TryShouldBeSuccess.shouldBeSuccess(cause.getClass(), cause.getMessage(), cause.getStackTrace()));
        }
    }

    private void assertIsFailure() {
        this.isNotNull();
        if (((Try)this.actual).isSuccess()) {
            this.throwAssertionError((ErrorMessageFactory)TryShouldBeFailure.shouldBeFailure());
        }
    }
}

