/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.vavr.api;

import io.vavr.collection.Seq;
import java.util.Comparator;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;

class SeqShouldBeSorted
extends BasicErrorMessageFactory {
    static <T> ErrorMessageFactory shouldBeSorted(int i, Seq<? extends T> group) {
        return new SeqShouldBeSorted("%nsequence is not sorted because element %s:%n <%s>%nis not less or equal than element %s:%n <%s>%nsequence was:%n <%s>", i, group.get(i), i + 1, group.get(i + 1), group);
    }

    static ErrorMessageFactory shouldHaveMutuallyComparableElements(Object actual) {
        return new SeqShouldBeSorted("%nsome elements are not mutually comparable in sequence:%n<%s>", actual);
    }

    static <T> ErrorMessageFactory shouldBeSortedAccordingToGivenComparator(int i, Seq<? extends T> actual, Comparator<?> comparator) {
        return new SeqShouldBeSorted("%nsequence is not sorted according to %s comparator because element %s:%n <%s>%nis not less or equal than element %s:%n <%s>%nsequence was:%n <%s>", comparator, i, actual.get(i), i + 1, actual.get(i + 1), actual);
    }

    private SeqShouldBeSorted(String format, Object ... arguments) {
        super(format, arguments);
    }
}

