/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.LockableMap;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ExpectedResponse;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.SendEventGeneratingActionCallback;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ChallengeAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.CoreSettingsAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.LoginAction;
import org.asteriskjava.manager.action.LogoffAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DialBeginEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerReaderImpl;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.manager.internal.ManagerWriterImpl;
import org.asteriskjava.manager.internal.ProtocolIdentifierWrapper;
import org.asteriskjava.manager.internal.ResponseEventsImpl;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.CoreSettingsResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.pbx.util.LogTime;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.SocketConnectionFacadeImpl;

public class ManagerConnectionImpl
extends Lockable
implements ManagerConnection,
Dispatcher {
    private static final int RECONNECTION_INTERVAL_1 = 50;
    private static final int RECONNECTION_INTERVAL_2 = 5000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5038;
    private static final int RECONNECTION_VERSION_INTERVAL = 500;
    private static final int MAX_VERSION_ATTEMPTS = 4;
    private static final String CMD_SHOW_VERSION = "core show version";
    private static final String[] SUPPORTED_AMI_VERSIONS = new String[]{"2.6", "2.7", "2.8", "2.9", "3.1", "3.2", "4.0", "5.0", "6.0", "7.0", "8.0", "9.0"};
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private static final Log logger = LogFactory.getLog(ManagerConnectionImpl.class);
    private final long id;
    private AtomicLong actionIdCounter = new AtomicLong(0L);
    private String hostname = "localhost";
    private int port = 5038;
    private boolean ssl = false;
    protected String username;
    protected String password;
    private Charset encoding = StandardCharsets.UTF_8;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private int socketTimeout = 0;
    private int socketReadTimeout = 0;
    private boolean keepAliveAfterAuthenticationFailure = true;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private final AtomicLong readerThreadCounter = new AtomicLong(0L);
    private final AtomicLong reconnectThreadCounter = new AtomicLong(0L);
    private ManagerReader reader;
    private ManagerWriter writer;
    private final ProtocolIdentifierWrapper protocolIdentifier;
    private AsteriskVersion version;
    private final LockableMap<String, SendActionCallback> responseListeners;
    private final LockableMap<String, ManagerEventListener> responseEventListeners;
    private final LockableList<ManagerEventListener> eventListeners;
    protected ManagerConnectionState state = ManagerConnectionState.INITIAL;
    private String eventMask;

    public ManagerConnectionImpl() {
        this.id = idCounter.getAndIncrement();
        this.responseListeners = new LockableMap(new HashMap());
        this.responseEventListeners = new LockableMap(new HashMap());
        this.eventListeners = new LockableList(new ArrayList());
        this.protocolIdentifier = new ProtocolIdentifierWrapper();
    }

    protected ManagerReader createReader(Dispatcher dispatcher, Object source) {
        return new ManagerReaderImpl(dispatcher, source);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port <= 0 ? 5038 : port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void setDefaultResponseTimeout(long defaultResponseTimeout) {
        this.defaultResponseTimeout = defaultResponseTimeout;
    }

    public void setDefaultEventTimeout(long defaultEventTimeout) {
        this.defaultEventTimeout = defaultEventTimeout;
    }

    @Override
    public void setKeepAliveAfterAuthenticationFailure(boolean keepAliveAfterAuthenticationFailure) {
        this.keepAliveAfterAuthenticationFailure = keepAliveAfterAuthenticationFailure;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public AsteriskVersion getVersion() {
        return this.version;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.socket.getRemoteAddress();
    }

    @Override
    public int getRemotePort() {
        return this.socket.getRemotePort();
    }

    @Override
    public void registerUserEventClass(Class<? extends ManagerEvent> userEventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.registerEventClass(userEventClass);
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public void setSocketReadTimeout(int socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    @Override
    public void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void login(String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        try (Locker.LockCloser closer = this.withLock();){
            if (this.state != ManagerConnectionState.INITIAL && this.state != ManagerConnectionState.DISCONNECTED) {
                throw new IllegalStateException("Login may only be perfomed when in state INITIAL or DISCONNECTED, but connection is in state " + (Object)((Object)this.state));
            }
            this.state = ManagerConnectionState.CONNECTING;
            this.eventMask = eventMask;
            try {
                this.doLogin(this.defaultResponseTimeout, eventMask);
            }
            finally {
                if (this.state != ManagerConnectionState.CONNECTED) {
                    this.state = ManagerConnectionState.DISCONNECTED;
                }
            }
        }
    }

    protected void doLogin(long timeout, String eventMask) throws IOException, AuthenticationFailedException, TimeoutException {
        try (Locker.LockCloser closer = this.withLock();){
            ManagerResponse loginResponse;
            String key;
            ManagerResponse challengeResponse;
            if (this.socket == null) {
                this.connect();
            }
            if (this.protocolIdentifier.getValue() == null) {
                try {
                    this.protocolIdentifier.await(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.protocolIdentifier.getValue() == null) {
                this.disconnect();
                if (this.reader != null && this.reader.getTerminationException() != null) {
                    throw this.reader.getTerminationException();
                }
                throw new TimeoutException("Timeout waiting for protocol identifier");
            }
            ChallengeAction challengeAction = new ChallengeAction("MD5");
            try {
                challengeResponse = this.sendAction(challengeAction);
            }
            catch (Exception e) {
                this.disconnect();
                throw new AuthenticationFailedException("Unable to send challenge action", e);
            }
            if (!(challengeResponse instanceof ChallengeResponse)) {
                this.disconnect();
                throw new AuthenticationFailedException("Unable to get challenge from Asterisk. ChallengeAction returned: " + challengeResponse.getMessage());
            }
            String challenge = ((ChallengeResponse)challengeResponse).getChallenge();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (challenge != null) {
                    md.update(challenge.getBytes(StandardCharsets.UTF_8));
                }
                if (this.password != null) {
                    md.update(this.password.getBytes(StandardCharsets.UTF_8));
                }
                key = ManagerUtil.toHexString(md.digest());
            }
            catch (NoSuchAlgorithmException ex) {
                this.disconnect();
                throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", ex);
            }
            LoginAction loginAction = new LoginAction(this.username, "MD5", key, eventMask);
            try {
                loginResponse = this.sendAction(loginAction);
            }
            catch (Exception e) {
                this.disconnect();
                throw new AuthenticationFailedException("Unable to send login action", e);
            }
            if (loginResponse instanceof ManagerError) {
                this.disconnect();
                throw new AuthenticationFailedException(loginResponse.getMessage());
            }
            logger.info("Successfully logged in");
            this.version = this.determineVersion();
            this.state = ManagerConnectionState.CONNECTED;
            this.writer.setTargetVersion(this.version);
            logger.info("Determined Asterisk version: " + this.version);
            ConnectEvent connectEvent = new ConnectEvent(this);
            connectEvent.setProtocolIdentifier(this.getProtocolIdentifier());
            connectEvent.setDateReceived(DateUtil.getDate());
            this.fireEvent(connectEvent, null);
        }
    }

    protected AsteriskVersion determineVersion() throws IOException, TimeoutException {
        int attempts = 0;
        logger.info("Got asterisk protocol identifier version " + this.protocolIdentifier.getValue());
        while (attempts++ < 4) {
            AsteriskVersion version2;
            try {
                version2 = this.determineVersionByCoreSettings();
                if (version2 != null) {
                    return version2;
                }
            }
            catch (Exception version2) {
                // empty catch block
            }
            try {
                version2 = this.determineVersionByCoreShowVersion();
                if (version2 != null) {
                    return version2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        logger.error("Unable to determine asterisk version, assuming " + AsteriskVersion.DEFAULT_VERSION + "... you should expect problems to follow.");
        return AsteriskVersion.DEFAULT_VERSION;
    }

    protected AsteriskVersion determineVersionByCoreSettings() throws Exception {
        ManagerResponse response = this.sendAction(new CoreSettingsAction());
        if (!(response instanceof CoreSettingsResponse)) {
            logger.info("Could not get core settings, do we have the necessary permissions?");
            return null;
        }
        String ver = ((CoreSettingsResponse)response).getAsteriskVersion();
        return AsteriskVersion.getDetermineVersionFromString("Asterisk " + ver);
    }

    protected AsteriskVersion determineVersionByCoreShowVersion() throws Exception {
        ManagerResponse coreShowVersionResponse = this.sendAction(new CommandAction(CMD_SHOW_VERSION));
        if (coreShowVersionResponse == null || !(coreShowVersionResponse instanceof CommandResponse)) {
            logger.info("Could not get response for 'core show version'");
            return null;
        }
        List<String> coreShowVersionResult = ((CommandResponse)coreShowVersionResponse).getResult();
        if (coreShowVersionResult == null || coreShowVersionResult.isEmpty()) {
            logger.warn("Got empty response for 'core show version'");
            return null;
        }
        String coreLine = coreShowVersionResult.get(0);
        return AsteriskVersion.getDetermineVersionFromString(coreLine);
    }

    protected void connect() throws IOException {
        try (Locker.LockCloser closer = this.withLock();){
            logger.info("Connecting to " + this.hostname + ":" + this.port);
            if (this.reader == null) {
                logger.debug("Creating reader for " + this.hostname + ":" + this.port);
                this.reader = this.createReader(this, this);
            }
            if (this.writer == null) {
                logger.debug("Creating writer");
                this.writer = this.createWriter();
            }
            logger.debug("Creating socket");
            this.socket = this.createSocket();
            logger.debug("Passing socket to reader");
            this.reader.setSocket(this.socket);
            if (this.readerThread == null || !this.readerThread.isAlive() || this.reader.isDead()) {
                logger.debug("Creating and starting reader thread");
                this.readerThread = new Thread(this.reader);
                this.readerThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reader-" + this.readerThreadCounter.getAndIncrement());
                this.readerThread.setDaemon(true);
                this.readerThread.start();
            }
            logger.debug("Passing socket to writer");
            this.writer.setSocket(this.socket);
        }
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.hostname, this.port, this.ssl, this.socketTimeout, this.socketReadTimeout, this.encoding);
    }

    @Override
    public void logoff() throws IllegalStateException {
        try (Locker.LockCloser closer = this.withLock();){
            if (this.state != ManagerConnectionState.CONNECTED && this.state != ManagerConnectionState.RECONNECTING) {
                throw new IllegalStateException("Logoff may only be perfomed when in state CONNECTED or RECONNECTING, but connection is in state " + (Object)((Object)this.state));
            }
            this.state = ManagerConnectionState.DISCONNECTING;
            if (this.socket != null) {
                try {
                    this.sendAction(new LogoffAction());
                }
                catch (Exception e) {
                    logger.warn("Unable to send LogOff action", e);
                }
            }
            this.cleanup();
            this.state = ManagerConnectionState.DISCONNECTED;
        }
    }

    protected void disconnect() {
        try (Locker.LockCloser closer = this.withLock();){
            if (this.socket != null) {
                logger.info("Closing socket.");
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    logger.warn("Unable to close socket: " + ex.getMessage());
                }
                this.socket = null;
            }
            this.protocolIdentifier.reset();
        }
    }

    @Override
    public ManagerResponse sendAction(ManagerAction action) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendAction(action, this.defaultResponseTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagerResponse sendAction(ManagerAction action, long timeout) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        DefaultSendActionCallback callbackHandler = new DefaultSendActionCallback();
        ManagerResponse response = null;
        try {
            this.sendAction(action, callbackHandler);
            if (action instanceof UserEventAction) {
                ManagerResponse managerResponse = null;
                return managerResponse;
            }
            try {
                response = callbackHandler.waitForResponse(timeout);
                if (response == null) {
                    throw new TimeoutException("Timeout waiting for response to " + action.getAction() + (action.getActionId() == null ? "" : " (actionId: " + action.getActionId() + "), Timeout=" + timeout + " Action=" + action.getAction()));
                }
            }
            catch (InterruptedException ex) {
                logger.warn("Interrupted while waiting for result");
                Thread.currentThread().interrupt();
            }
        }
        finally {
            callbackHandler.dispose();
        }
        return response;
    }

    @Override
    public void sendAction(ManagerAction action, SendActionCallback callback) throws IOException, IllegalArgumentException, IllegalStateException {
        Class<? extends ManagerResponse> responseClass;
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!((this.state == ManagerConnectionState.CONNECTING || this.state == ManagerConnectionState.RECONNECTING) && (action instanceof ChallengeAction || action instanceof LoginAction || this.isShowVersionCommandAction(action)) || this.state == ManagerConnectionState.DISCONNECTING && action instanceof LogoffAction || this.state == ManagerConnectionState.CONNECTED)) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: socket not connected.");
        }
        String internalActionId = this.createInternalActionId();
        if (callback != null) {
            try (Locker.LockCloser closer = this.responseListeners.withLock();){
                this.responseListeners.put(internalActionId, callback);
            }
        }
        if ((responseClass = this.getExpectedResponseClass(action.getClass())) != null) {
            this.reader.expectResponseClass(internalActionId, responseClass);
        }
        this.writer.sendAction(action, internalActionId);
    }

    boolean isShowVersionCommandAction(ManagerAction action) {
        if (action instanceof CoreSettingsAction) {
            return true;
        }
        if (action instanceof CommandAction) {
            String cmd = ((CommandAction)action).getCommand();
            return CMD_SHOW_VERSION.equals(cmd);
        }
        return false;
    }

    private Class<? extends ManagerResponse> getExpectedResponseClass(Class<? extends ManagerAction> actionClass) {
        ExpectedResponse annotation = actionClass.getAnnotation(ExpectedResponse.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendEventGeneratingAction(action, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction action, long timeout) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        Throwable throwable;
        Locker.LockCloser closer;
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (action.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + action.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(action.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + action.getActionCompleteEventClass().getName() + ") for " + action.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED but connection is in state " + (Object)((Object)this.state));
        }
        ResponseEventsImpl responseEvents = new ResponseEventsImpl();
        ResponseEventHandler responseEventHandler = new ResponseEventHandler(responseEvents, action.getActionCompleteEventClass());
        String internalActionId = this.createInternalActionId();
        try {
            String string;
            closer = this.responseListeners.withLock();
            throwable = null;
            try {
                this.responseListeners.put(internalActionId, responseEventHandler);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
            closer = this.responseEventListeners.withLock();
            throwable = null;
            try {
                this.responseEventListeners.put(internalActionId, responseEventHandler);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
            this.writer.sendAction(action, internalActionId);
            if (responseEvents.getResponse() == null || !responseEvents.isComplete()) {
                try {
                    responseEvents.await(timeout);
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted while waiting for response events.");
                    Thread.currentThread().interrupt();
                }
            }
            if (responseEvents.getResponse() != null) {
                if (responseEvents.isComplete()) return responseEvents;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Timeout waiting for response or response events to ").append(action.getAction());
            if (action.getActionId() == null) {
                string = "";
                throw new EventTimeoutException(stringBuilder.append(string).toString(), responseEvents);
            }
            string = " (actionId: " + action.getActionId() + ")";
            throw new EventTimeoutException(stringBuilder.append(string).toString(), responseEvents);
        }
        finally {
            closer = this.responseEventListeners.withLock();
            throwable = null;
            try {
                this.responseEventListeners.remove(internalActionId);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
            closer = this.responseListeners.withLock();
            throwable = null;
            try {
                this.responseListeners.remove(internalActionId);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (closer != null) {
                    if (throwable != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
    }

    @Override
    public void sendEventGeneratingAction(EventGeneratingAction action, SendEventGeneratingActionCallback callback) throws IOException, IllegalArgumentException, IllegalStateException {
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (action.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + action.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(action.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + action.getActionCompleteEventClass().getName() + ") for " + action.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED but connection is in state " + (Object)((Object)this.state));
        }
        String internalActionId = this.createInternalActionId();
        if (callback != null) {
            AsyncEventGeneratingResponseHandler responseEventHandler = new AsyncEventGeneratingResponseHandler(action.getActionCompleteEventClass(), callback);
            try (Locker.LockCloser closer = this.responseListeners.withLock();){
                this.responseListeners.put(internalActionId, responseEventHandler);
            }
            closer = this.responseEventListeners.withLock();
            var6_6 = null;
            try {
                this.responseEventListeners.put(internalActionId, responseEventHandler);
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (closer != null) {
                    if (var6_6 != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        }
        this.writer.sendAction(action, internalActionId);
    }

    private String createInternalActionId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hashCode());
        sb.append("_");
        sb.append(this.actionIdCounter.getAndIncrement());
        return sb.toString();
    }

    @Override
    public void addEventListener(ManagerEventListener listener) {
        try (Locker.LockCloser closer = this.eventListeners.withLock();){
            if (!this.eventListeners.contains(listener)) {
                this.eventListeners.add(listener);
            }
        }
    }

    @Override
    public void removeEventListener(ManagerEventListener listener) {
        try (Locker.LockCloser closer = this.eventListeners.withLock();){
            if (this.eventListeners.contains(listener)) {
                this.eventListeners.remove(listener);
            }
        }
    }

    @Override
    public String getProtocolIdentifier() {
        return this.protocolIdentifier.getValue();
    }

    @Override
    public ManagerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchResponse(ManagerResponse response, Integer requiredHandlingTime) {
        if (response == null) {
            logger.error("Unable to dispatch null response. This should never happen. Please file a bug.");
            return;
        }
        String actionId = response.getActionId();
        String internalActionId = null;
        SendActionCallback listener = null;
        if (actionId != null) {
            internalActionId = ManagerUtil.getInternalActionId(actionId);
            response.setActionId(ManagerUtil.stripInternalActionId(actionId));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dispatching response with internalActionId '" + internalActionId + "':\n" + response);
        }
        if (internalActionId != null) {
            try (Locker.LockCloser closer = this.responseListeners.withLock();){
                listener = this.responseListeners.get(internalActionId);
                if (listener != null) {
                    this.responseListeners.remove(internalActionId);
                }
                logger.debug("No response listener registered for internalActionId '" + internalActionId + "'");
            }
        } else {
            logger.error("Unable to retrieve internalActionId from response: actionId '" + actionId + "':\n" + response);
        }
        if (listener != null) {
            LogTime timer = new LogTime();
            try {
                listener.onResponse(response);
            }
            catch (Exception e) {
                logger.warn("Unexpected exception in response listener " + listener.getClass().getName(), e);
            }
            finally {
                if (requiredHandlingTime != null && timer.timeTaken() > (long)requiredHandlingTime.intValue()) {
                    logger.warn("Slow processing of event " + listener.getClass().getCanonicalName() + " " + timer.timeTaken() + "MS \n" + response);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(ManagerEvent event, Integer requiredHandlingTime) {
        block39: {
            Object internalActionId;
            block38: {
                ResponseEvent responseEvent;
                if (event == null) {
                    logger.error("Unable to dispatch null event. This should never happen. Please file a bug.");
                    return;
                }
                this.dispatchLegacyEventIfNeeded(event, requiredHandlingTime);
                if (logger.isDebugEnabled()) {
                    logger.debug("Dispatching event:\n" + event.toString());
                }
                if (event instanceof ResponseEvent && (internalActionId = (responseEvent = (ResponseEvent)event).getInternalActionId()) != null) {
                    try (Locker.LockCloser closer = this.responseEventListeners.withLock();){
                        ManagerEventListener listener = this.responseEventListeners.get(internalActionId);
                        if (listener == null) break block38;
                        LogTime timer = new LogTime();
                        try {
                            listener.onManagerEvent(event);
                        }
                        catch (Exception e) {
                            logger.warn("Unexpected exception in response event listener " + listener.getClass().getName(), e);
                        }
                        finally {
                            if (requiredHandlingTime != null && timer.timeTaken() > (long)requiredHandlingTime.intValue()) {
                                logger.warn("Slow processing of event " + listener.getClass().getCanonicalName() + " " + timer.timeTaken() + "MS \n" + event);
                            }
                        }
                    }
                }
            }
            if (event instanceof DisconnectEvent) {
                this.cleanupActionListeners((DisconnectEvent)event);
                Locker.LockCloser closer = this.withLock();
                internalActionId = null;
                try {
                    if (this.state == ManagerConnectionState.CONNECTED) {
                        this.state = ManagerConnectionState.RECONNECTING;
                        this.cleanup();
                        Thread reconnectThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ManagerConnectionImpl.this.reconnect();
                            }
                        });
                        reconnectThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reconnect-" + this.reconnectThreadCounter.getAndIncrement());
                        reconnectThread.setDaemon(true);
                        reconnectThread.start();
                        break block39;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    internalActionId = throwable;
                    throw throwable;
                }
                finally {
                    if (closer != null) {
                        if (internalActionId != null) {
                            try {
                                closer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)internalActionId).addSuppressed(throwable);
                            }
                        } else {
                            closer.close();
                        }
                    }
                }
            }
        }
        if (event instanceof ProtocolIdentifierReceivedEvent) {
            ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = (ProtocolIdentifierReceivedEvent)event;
            String protocolIdentifier = protocolIdentifierReceivedEvent.getProtocolIdentifier();
            this.setProtocolIdentifier(protocolIdentifier);
            return;
        }
        this.fireEvent(event, requiredHandlingTime);
    }

    private void dispatchLegacyEventIfNeeded(ManagerEvent event, Integer requiredHandlingTime) {
        if (event instanceof DialBeginEvent) {
            DialEvent legacyEvent = new DialEvent((DialBeginEvent)event);
            this.dispatchEvent(legacyEvent, requiredHandlingTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ManagerEvent event, Integer requiredHandlingTime) {
        try (Locker.LockCloser closer = this.eventListeners.withLock();){
            for (ManagerEventListener listener : this.eventListeners) {
                LogTime timer = new LogTime();
                try {
                    listener.onManagerEvent(event);
                }
                catch (RuntimeException e) {
                    logger.warn("Unexpected exception in eventHandler " + listener.getClass().getName(), e);
                }
                finally {
                    if (requiredHandlingTime == null || timer.timeTaken() <= (long)requiredHandlingTime.intValue()) continue;
                    logger.warn("Slow processing of event " + listener.getClass().getCanonicalName() + " " + timer.timeTaken() + "MS \n" + event);
                }
            }
        }
    }

    private boolean isSupportedProtocolIdentifier(String identifier) {
        for (String supportedVersion : SUPPORTED_AMI_VERSIONS) {
            String prefix = "Asterisk Call Manager/" + supportedVersion + ".";
            if (!identifier.startsWith(prefix)) continue;
            return true;
        }
        if ("OpenPBX Call Manager/1.0".equals(identifier)) {
            return true;
        }
        if ("CallWeaver Call Manager/1.0".equals(identifier)) {
            return true;
        }
        return identifier.startsWith("Asterisk Call Manager Proxy/");
    }

    private void setProtocolIdentifier(String identifier) {
        logger.info("Connected via " + identifier);
        if (identifier == null || !this.isSupportedProtocolIdentifier(identifier)) {
            logger.warn("Unsupported protocol version '" + identifier + "'. Use at your own risk.");
        }
        this.protocolIdentifier.setValue(identifier);
    }

    /*
     * Exception decompiling
     */
    private void reconnect() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanupActionListeners(DisconnectEvent event) {
        HashMap<String, SendActionCallback> oldResponseListeners = null;
        Locker.LockCloser closer = this.responseListeners.withLock();
        Iterator<ManagerEventListener> iterator = null;
        try {
            oldResponseListeners = new HashMap<String, SendActionCallback>(this.responseListeners);
            this.responseListeners.clear();
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (closer != null) {
                if (iterator != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    closer.close();
                }
            }
        }
        for (SendActionCallback responseListener : oldResponseListeners.values()) {
            try {
                responseListener.onResponse(null);
            }
            catch (Exception ex) {
                logger.warn("Exception notifying responseListener.onResponse(null)", ex);
            }
        }
        HashMap<String, ManagerEventListener> oldResponseEventListeners = null;
        try (Locker.LockCloser closer2 = this.responseEventListeners.withLock();){
            oldResponseEventListeners = new HashMap<String, ManagerEventListener>(this.responseEventListeners);
            this.responseEventListeners.clear();
        }
        for (String discardedInternalActionId : oldResponseListeners.keySet()) {
            oldResponseEventListeners.remove(discardedInternalActionId);
        }
        for (ManagerEventListener responseEventListener : oldResponseEventListeners.values()) {
            try {
                responseEventListener.onManagerEvent(event);
            }
            catch (Exception ex) {
                logger.warn("Exception notifying responseListener.onManagerEvent(DisconnectEvent)", ex);
            }
        }
    }

    private void cleanup() {
        this.disconnect();
        this.readerThread = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ManagerConnection[");
        sb.append("id='").append(this.id).append("',");
        sb.append("hostname='").append(this.hostname).append("',");
        sb.append("port=").append(this.port).append(",");
        sb.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return sb.toString();
    }

    @Override
    public void deregisterEventClass(Class<? extends ManagerEvent> eventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.deregisterEventClass(eventClass);
    }

    @Override
    public void stop() {
    }

    private class AsyncEventGeneratingResponseHandler
    implements SendActionCallback,
    ManagerEventListener {
        private final Class<? extends ResponseEvent> actionCompleteEventClass;
        private final SendEventGeneratingActionCallback callback;
        private final ResponseEventsImpl events;

        public AsyncEventGeneratingResponseHandler(Class<? extends ResponseEvent> actionCompleteEventClass, SendEventGeneratingActionCallback callback) {
            this.actionCompleteEventClass = actionCompleteEventClass;
            this.callback = callback;
            this.events = new ResponseEventsImpl();
        }

        @Override
        public void onManagerEvent(ManagerEvent event) {
            if (event instanceof DisconnectEvent) {
                this.callback.onResponse(this.events);
                return;
            }
            if (!(event instanceof ResponseEvent)) {
                return;
            }
            ResponseEvent responseEvent = (ResponseEvent)event;
            this.events.addEvent(responseEvent);
            if (this.actionCompleteEventClass.isAssignableFrom(event.getClass())) {
                this.events.setComplete(true);
                String internalActionId = responseEvent.getInternalActionId();
                try (Locker.LockCloser closer = ManagerConnectionImpl.this.responseEventListeners.withLock();){
                    ManagerConnectionImpl.this.responseEventListeners.remove(internalActionId);
                }
                this.callback.onResponse(this.events);
            }
        }

        @Override
        public void onResponse(ManagerResponse response) {
            if (response == null) {
                this.callback.onResponse(this.events);
                return;
            }
            this.events.setRepsonse(response);
            if (response instanceof ManagerError) {
                this.events.setComplete(true);
            }
            if (this.events.isComplete()) {
                this.callback.onResponse(this.events);
            }
        }
    }

    private static class ResponseEventHandler
    implements ManagerEventListener,
    SendActionCallback {
        private final ResponseEventsImpl events;
        private final Class<?> actionCompleteEventClass;

        public ResponseEventHandler(ResponseEventsImpl events, Class<?> actionCompleteEventClass) {
            this.events = events;
            this.actionCompleteEventClass = actionCompleteEventClass;
        }

        @Override
        public void onManagerEvent(ManagerEvent event) {
            if (event instanceof DisconnectEvent) {
                this.events.setComplete(true);
                this.events.countDown();
                return;
            }
            if (event instanceof ResponseEvent) {
                ResponseEvent responseEvent = (ResponseEvent)event;
                this.events.addEvent(responseEvent);
            }
            if (this.actionCompleteEventClass.isAssignableFrom(event.getClass())) {
                this.events.setComplete(true);
                if (this.events.getResponse() != null) {
                    this.events.countDown();
                }
            }
        }

        @Override
        public void onResponse(ManagerResponse response) {
            if (response == null) {
                this.events.setComplete(true);
                this.events.countDown();
                return;
            }
            this.events.setRepsonse(response);
            if (response instanceof ManagerError) {
                this.events.setComplete(true);
            }
            if (this.events.isComplete()) {
                this.events.countDown();
            }
        }
    }

    private static class DefaultSendActionCallback
    implements SendActionCallback,
    Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile boolean disposed = false;
        private LogTime timer = new LogTime();

        private DefaultSendActionCallback() {
        }

        private ManagerResponse waitForResponse(long timeout) throws InterruptedException {
            this.latch.await(timeout, TimeUnit.MILLISECONDS);
            return this.response;
        }

        @Override
        public void onResponse(ManagerResponse response) {
            this.response = response;
            if (this.disposed) {
                logger.error("Response arrived after Disposal and assumably Timeout " + response + " elapsed: " + this.timer.timeTaken() + "(MS)");
                logger.error("" + response.getDateReceived());
            }
            this.latch.countDown();
        }

        private void dispose() {
            this.disposed = true;
        }
    }
}

