/*
 * Decompiled with CFR 0.152.
 */
package org.asyncflows.apt;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.asyncflows.apt.ProxyGenerator;
import org.asyncflows.apt.TypeAnalyser;

@SupportedAnnotationTypes(value={"org.asyncflows.core.annotations.Asynchronous"})
public class AsynchronousProxyProcessor
extends AbstractProcessor {
    public static final String ASYNCHRONOUS_NAME = "org.asyncflows.core.annotations.Asynchronous";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            String name = typeElement.getQualifiedName().toString();
            if (!ASYNCHRONOUS_NAME.equals(name)) continue;
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            Map<Boolean, List<Element>> annotatedMethods = annotatedElements.stream().collect(Collectors.partitioningBy(element -> element.getKind() == ElementKind.INTERFACE && element.asType() instanceof DeclaredType));
            List<Element> interfaces = annotatedMethods.get(true);
            List<Element> others = annotatedMethods.get(false);
            others.forEach(e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@Asynchronous should be attached only to interface types (" + (Object)((Object)annotation.getKind()) + ")", (Element)e));
            for (Element element2 : interfaces) {
                TypeElement typeElement2 = (TypeElement)element2;
                TypeAnalyser analyser = new TypeAnalyser(this.processingEnv, typeElement2);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating proxy for " + analyser.getInterfaceQName());
                try {
                    JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(analyser.getFactoryQName(), typeElement2);
                    PrintWriter out = new PrintWriter(builderFile.openWriter());
                    Throwable throwable = null;
                    try {
                        new ProxyGenerator(out, analyser).generate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to create proxy: " + analyser.getInterfaceQName(), ex);
                }
            }
        }
        return true;
    }

    public List<TypeParameterElement> getTypeParameters(TypeElement typeElement) {
        return typeElement.getTypeParameters();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

