/*
 * Decompiled with CFR 0.152.
 */
package org.asyncflows.apt;

import java.io.PrintWriter;
import java.util.Objects;
import org.asyncflows.apt.AsynchronousProxyProcessor;
import org.asyncflows.apt.TypeAnalyser;

public final class ProxyGenerator {
    private static final String OBJECT = "java.lang.Object";
    private static final String VAT = "org.asyncflows.core.vats.Vat";
    private static final String IDENT = "    ";
    private final PrintWriter writer;
    private final TypeAnalyser type;
    private int identLevel;
    private boolean lineStarted;

    public ProxyGenerator(PrintWriter writer, TypeAnalyser type) {
        this.writer = writer;
        this.type = type;
    }

    public void generate() {
        this.line("package " + this.type.getPackageName() + ";");
        this.line();
        this.line("/**");
        this.line(" * The asynchronous proxy factory for {@link " + this.type.getInterfaceQName() + "}.");
        this.line(" */");
        this.line("@javax.annotation.Generated(\"" + AsynchronousProxyProcessor.class.getName() + "\")");
        this.write("public final class " + this.type.getFactoryName() + " implements java.util.function.BiFunction<" + VAT + ", " + OBJECT + ", " + OBJECT + ">, org.asyncflows.core.util.AsynchronousService").block(() -> {
            this.line("public static final " + this.type.getFactoryName() + " INSTANCE = new " + this.type.getFactoryName() + "();");
            this.line();
            this.createProxyJDoc();
            this.write("public static " + this.type.getProxyTypeParametersWithBounds() + " " + this.type.getInterfaceType() + " createProxy(" + VAT + " vat, " + this.type.getInterfaceType() + " service)").block(() -> this.line("return new " + this.type.getProxyName() + this.type.getProxyTypeParametersWithoutBounds() + "(vat, service);"));
            this.line();
            this.createProxyJDoc();
            this.write("public " + this.type.getProxyTypeParametersWithBounds() + " " + this.type.getInterfaceType() + " export(" + VAT + " vat, " + this.type.getInterfaceType() + " service)").block(() -> this.line("return createProxy(vat, service);"));
            this.line();
            this.line("@Override");
            this.line("@SuppressWarnings(\"unchecked\")");
            this.write("public java.lang.Object apply(org.asyncflows.core.vats.Vat vat, java.lang.Object service)").block(() -> this.line("return createProxy(vat, (" + this.type.getInterfaceQName() + ") service);"));
            this.line();
            this.generateProxyClass();
        });
    }

    public void createProxyJDoc() {
        this.line("/**");
        this.line(" * Create a proxy.");
        this.line(" *");
        this.line(" * @param vat     the vat");
        this.line(" * @param service the service to export");
        for (String typeParameter : this.type.getTypeParameters()) {
            this.line(" * @param <" + typeParameter + "> a type parameter");
        }
        this.line(" * @return the exported service");
        this.line(" */");
    }

    private void generateProxyClass() {
        String typeParametersWithBounds = this.type.getProxyTypeParametersWithBounds();
        this.line("@javax.annotation.Generated(\"" + AsynchronousProxyProcessor.class.getName() + "\")");
        this.write("private static final class " + this.type.getProxyName() + typeParametersWithBounds + " implements " + this.type.getInterfaceType()).block(() -> {
            this.line("private final org.asyncflows.core.vats.Vat vat;");
            this.line("private final " + this.type.getInterfaceType() + " service;");
            this.line();
            this.write("private " + this.type.getProxyName() + "(final " + VAT + " vat, final " + this.type.getInterfaceType() + " service)").block(() -> {
                this.line("java.util.Objects.requireNonNull(vat);");
                this.line("java.util.Objects.requireNonNull(service);");
                this.line("this.vat = vat;");
                this.line("this.service = service;");
            });
            this.line();
            this.line("@Override");
            this.write("public int hashCode()").block(() -> this.line("return System.identityHashCode(service);"));
            this.line();
            this.line("@Override");
            this.write("public boolean equals(java.lang.Object o2)").block(() -> this.line("return this == o2 || (o2 != null && o2.getClass() == getClass() && ((" + this.type.getProxyName() + ")o2).service == this.service);"));
            for (TypeAnalyser.MethodInfo method : this.type.getAllMethods()) {
                this.line();
                this.line("@Override");
                this.write("public " + method.getSignature()).block(() -> {
                    if (method.isPromise()) {
                        this.line("return org.asyncflows.core.CoreFlows.aLater(this.vat, () -> this.service." + method.getInvoke() + ");");
                    } else if (method.isOneWay()) {
                        this.line("org.asyncflows.core.CoreFlows.aOneWay(this.vat, () -> this.service." + method.getInvoke() + ");");
                    } else {
                        this.line("throw new java.lang.UnsupportedOperationException();");
                    }
                });
            }
        });
    }

    private ProxyGenerator write(Object value) {
        if (!this.lineStarted) {
            this.lineStarted = true;
            for (int i = 0; i < this.identLevel; ++i) {
                this.writer.write(IDENT);
            }
        }
        this.writer.write(Objects.toString(value));
        return this;
    }

    private void line() {
        this.writer.println();
        this.lineStarted = false;
    }

    private void line(Object value) {
        this.write(value).line();
    }

    private void block(Runnable block) {
        this.start();
        block.run();
        this.end();
    }

    private void start() {
        this.line(" {");
        ++this.identLevel;
    }

    private void end() {
        --this.identLevel;
        this.line("}");
    }
}

