/*
 * Decompiled with CFR 0.152.
 */
package org.asyncflows.apt;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.TypeKindVisitor8;

public final class TypeAnalyser {
    private final ProcessingEnvironment processingEnvironment;
    private final TypeElement typeElement;

    public TypeAnalyser(ProcessingEnvironment processingEnvironment, TypeElement typeElement) {
        this.processingEnvironment = processingEnvironment;
        this.typeElement = typeElement;
    }

    private static <T> void forEachAsList(Iterable<T> collection, Consumer<T> action, Runnable between) {
        boolean isFirst = true;
        for (T t : collection) {
            if (isFirst) {
                isFirst = false;
            } else {
                between.run();
            }
            action.accept(t);
        }
    }

    public String getPackageName() {
        return this.processingEnvironment.getElementUtils().getPackageOf(this.typeElement).getQualifiedName().toString();
    }

    public String getProxyName() {
        return this.typeElement.getSimpleName() + "AsyncProxy";
    }

    public String getProxyTypeParametersWithBounds() {
        String typeParameters = this.typeElement.getTypeParameters().stream().map(t -> this.typeWithBounds(t.asType())).collect(Collectors.joining(", "));
        return typeParameters.isEmpty() ? "" : "<" + typeParameters + ">";
    }

    public List<String> getTypeParameters() {
        return this.typeElement.getTypeParameters().stream().map(p -> p).map(Object::toString).collect(Collectors.toList());
    }

    public String getInterfaceQName() {
        return this.typeElement.getQualifiedName().toString();
    }

    public String getInterfaceType() {
        return this.getInterfaceQName() + this.getProxyTypeParametersWithoutBounds();
    }

    public String getProxyTypeParametersWithoutBounds() {
        String typeParameters = this.typeElement.getTypeParameters().stream().map(p -> p).map(Object::toString).collect(Collectors.joining(", "));
        return typeParameters.isEmpty() ? "" : "<" + typeParameters + ">";
    }

    public List<MethodInfo> getAllMethods() {
        return this.processingEnvironment.getElementUtils().getAllMembers(this.typeElement).stream().filter(e -> e instanceof ExecutableElement).map(e -> (ExecutableElement)e).filter(e -> !e.isDefault() && !e.getModifiers().contains((Object)Modifier.STATIC) && !e.getEnclosingElement().asType().toString().equals("java.lang.Object")).map(x$0 -> new MethodInfo((ExecutableElement)x$0)).collect(Collectors.toList());
    }

    private String typeWithBounds(TypeMirror type) {
        StringBuilder out = new StringBuilder();
        this.printType(type, out, true);
        return out.toString();
    }

    private void printType(TypeMirror type, final StringBuilder out, boolean printBounds) {
        type.accept(new TypeKindVisitor8<Void, Boolean>(){

            @Override
            public Void visitIntersection(IntersectionType t, Boolean bounds) {
                TypeAnalyser.forEachAsList(t.getBounds(), b -> b.accept(this, false), () -> out.append(" & "));
                return null;
            }

            @Override
            public Void visitUnion(UnionType t, Boolean bounds) {
                TypeAnalyser.forEachAsList(t.getAlternatives(), b -> b.accept(this, false), () -> out.append(" | "));
                return null;
            }

            @Override
            public Void visitPrimitive(PrimitiveType t, Boolean bounds) {
                out.append(t.getKind().name().toLowerCase(Locale.US));
                return null;
            }

            @Override
            public Void visitNoTypeAsVoid(NoType t, Boolean bounds) {
                out.append("void");
                return null;
            }

            @Override
            public Void visitArray(ArrayType t, Boolean bounds) {
                t.getComponentType().accept(this, false);
                out.append("[]");
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, Boolean bounds) {
                out.append(((TypeElement)t.asElement()).getQualifiedName());
                if (!t.getTypeArguments().isEmpty()) {
                    out.append('<');
                    TypeAnalyser.forEachAsList(t.getTypeArguments(), a -> a.accept(this, false), () -> out.append(", "));
                    out.append('>');
                }
                return null;
            }

            @Override
            public Void visitTypeVariable(TypeVariable t, Boolean bounds) {
                out.append(t.asElement().getSimpleName());
                if (bounds.booleanValue()) {
                    if (t.getLowerBound() instanceof NullType) {
                        if (TypeAnalyser.this.isNonEmptyType(t.getUpperBound())) {
                            out.append(" extends ");
                            t.getUpperBound().accept(this, false);
                        }
                    } else {
                        out.append(" super ");
                        t.getLowerBound().accept(this, false);
                    }
                }
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, Boolean bounds) {
                out.append("?");
                if (t.getSuperBound() == null || t.getSuperBound() instanceof NullType) {
                    if (TypeAnalyser.this.isNonEmptyType(t.getExtendsBound())) {
                        out.append(" extends ");
                        t.getExtendsBound().accept(this, false);
                    }
                } else {
                    out.append(" super ");
                    t.getSuperBound().accept(this, false);
                }
                return null;
            }
        }, printBounds);
    }

    private boolean isNonEmptyType(TypeMirror t) {
        if (t == null || t.getKind() == TypeKind.NULL) {
            return false;
        }
        if (t.getKind() != TypeKind.DECLARED) {
            return true;
        }
        return !((TypeElement)((DeclaredType)t).asElement()).getQualifiedName().toString().equals(Object.class.getName());
    }

    public String getFactoryQName() {
        return this.getPackageName() + "." + this.getFactoryName();
    }

    public String getFactoryName() {
        return this.typeElement.getSimpleName() + "ProxyFactory";
    }

    public final class MethodInfo {
        private final ExecutableElement element;
        private final ExecutableType type;

        public MethodInfo(ExecutableElement element) {
            this.element = element;
            this.type = (ExecutableType)TypeAnalyser.this.processingEnvironment.getTypeUtils().asMemberOf((DeclaredType)TypeAnalyser.this.typeElement.asType(), element);
        }

        public String getSignature() {
            StringBuilder b = new StringBuilder();
            List<? extends TypeVariable> typeVariables = this.type.getTypeVariables();
            if (!typeVariables.isEmpty()) {
                b.append('<');
                TypeAnalyser.forEachAsList(typeVariables, t -> TypeAnalyser.this.printType(t, b, true), () -> b.append(", "));
                b.append("> ");
            }
            TypeAnalyser.this.printType(this.type.getReturnType(), b, false);
            b.append(' ');
            b.append(this.element.getSimpleName());
            b.append('(');
            for (int i = 0; i < this.element.getParameters().size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                TypeAnalyser.this.printType(this.type.getParameterTypes().get(i), b, false);
                b.append(' ');
                b.append(this.element.getParameters().get(i).getSimpleName());
            }
            b.append(')');
            return b.toString();
        }

        public String getInvoke() {
            StringBuilder b = new StringBuilder();
            b.append(this.element.getSimpleName());
            b.append('(');
            TypeAnalyser.forEachAsList(this.element.getParameters(), p -> b.append(p.getSimpleName()), () -> b.append(", "));
            b.append(')');
            return b.toString();
        }

        public boolean isPromise() {
            return "org.asyncflows.core.Promise".equals(this.getErasedReturnType());
        }

        public boolean isOneWay() {
            return this.type.getReturnType().getKind() == TypeKind.VOID;
        }

        private String getErasedReturnType() {
            return TypeAnalyser.this.processingEnvironment.getTypeUtils().erasure(this.type.getReturnType()).toString();
        }
    }
}

