/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.retrofit;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Request;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.extras.retrofit.AsyncHttpClientCall;

public final class AsyncHttpClientCallFactory
implements Call.Factory {
    @NonNull
    private final AsyncHttpClient httpClient;
    private final List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;

    public Call newCall(Request request) {
        AsyncHttpClientCall.AsyncHttpClientCallBuilder callBuilder = AsyncHttpClientCall.builder().httpClient(this.httpClient).request(request);
        AsyncHttpClientCall.runConsumers(this.callCustomizers, callBuilder);
        return callBuilder.build();
    }

    @ConstructorProperties(value={"httpClient", "callCustomizers"})
    AsyncHttpClientCallFactory(@NonNull AsyncHttpClient httpClient, List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        this.httpClient = httpClient;
        this.callCustomizers = callCustomizers;
    }

    public static AsyncHttpClientCallFactoryBuilder builder() {
        return new AsyncHttpClientCallFactoryBuilder();
    }

    public AsyncHttpClientCallFactoryBuilder toBuilder() {
        return new AsyncHttpClientCallFactoryBuilder().httpClient(this.httpClient).callCustomizers(this.callCustomizers);
    }

    @NonNull
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> getCallCustomizers() {
        return this.callCustomizers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncHttpClientCallFactory)) {
            return false;
        }
        AsyncHttpClientCallFactory other = (AsyncHttpClientCallFactory)o;
        AsyncHttpClient this$httpClient = this.getHttpClient();
        AsyncHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> this$callCustomizers = this.getCallCustomizers();
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> other$callCustomizers = other.getCallCustomizers();
        return !(this$callCustomizers == null ? other$callCustomizers != null : !((Object)this$callCustomizers).equals(other$callCustomizers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AsyncHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> $callCustomizers = this.getCallCustomizers();
        result = result * 59 + ($callCustomizers == null ? 43 : ((Object)$callCustomizers).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncHttpClientCallFactory(httpClient=" + this.getHttpClient() + ", callCustomizers=" + this.getCallCustomizers() + ")";
    }

    public static class AsyncHttpClientCallFactoryBuilder {
        private AsyncHttpClient httpClient;
        private ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;

        AsyncHttpClientCallFactoryBuilder() {
        }

        public AsyncHttpClientCallFactoryBuilder httpClient(AsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizer(Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder> callCustomizer) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.add(callCustomizer);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizers(Collection<? extends Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.addAll(callCustomizers);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder clearCallCustomizers() {
            if (this.callCustomizers != null) {
                this.callCustomizers.clear();
            }
            return this;
        }

        public AsyncHttpClientCallFactory build() {
            List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;
            switch (this.callCustomizers == null ? 0 : this.callCustomizers.size()) {
                case 0: {
                    callCustomizers = Collections.emptyList();
                    break;
                }
                case 1: {
                    callCustomizers = Collections.singletonList(this.callCustomizers.get(0));
                    break;
                }
                default: {
                    callCustomizers = Collections.unmodifiableList(new ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>>(this.callCustomizers));
                }
            }
            return new AsyncHttpClientCallFactory(this.httpClient, callCustomizers);
        }

        public String toString() {
            return "AsyncHttpClientCallFactory.AsyncHttpClientCallFactoryBuilder(httpClient=" + this.httpClient + ", callCustomizers=" + this.callCustomizers + ")";
        }
    }
}

