/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;

public final class ByteBufUtils {
    private ByteBufUtils() {
    }

    public static String byteBuf2String(Charset charset, ByteBuf buf) throws CharacterCodingException {
        if (charset == StandardCharsets.UTF_8 || charset == StandardCharsets.US_ASCII) {
            return Utf8ByteBufCharsetDecoder.decodeUtf8(buf);
        }
        return buf.toString(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String byteBuf2String(Charset charset, ByteBuf ... bufs) throws CharacterCodingException {
        if (charset == StandardCharsets.UTF_8 || charset == StandardCharsets.US_ASCII) {
            return Utf8ByteBufCharsetDecoder.decodeUtf8(bufs);
        }
        CompositeByteBuf composite = Unpooled.compositeBuffer((int)bufs.length);
        try {
            for (ByteBuf buf : bufs) {
                buf.retain();
                composite.addComponent(buf);
            }
            String string = composite.toString(charset);
            return string;
        }
        finally {
            composite.release();
        }
    }

    public static byte[] byteBuf2Bytes(ByteBuf buf) {
        byte[] array;
        int readable = buf.readableBytes();
        int readerIndex = buf.readerIndex();
        if (buf.hasArray()) {
            array = buf.array();
            if (buf.arrayOffset() == 0 && readerIndex == 0 && array.length == readable) {
                return array;
            }
        }
        array = new byte[readable];
        buf.getBytes(readerIndex, array);
        return array;
    }
}

