/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.channel.ChannelPool;
import org.asynchttpclient.channel.ChannelPoolPartitionSelector;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultChannelPool
implements ChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChannelPool.class);
    private final ConcurrentHashMap<Object, ConcurrentLinkedDeque<IdleChannel>> partitions = new ConcurrentHashMap();
    private final ConcurrentHashMap<ChannelId, ChannelCreation> channelId2Creation;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final Timer nettyTimer;
    private final int connectionTtl;
    private final boolean connectionTtlEnabled;
    private final int maxIdleTime;
    private final boolean maxIdleTimeEnabled;
    private final long cleanerPeriod;

    public DefaultChannelPool(AsyncHttpClientConfig config, Timer hashedWheelTimer) {
        this(config.getPooledConnectionIdleTimeout(), config.getConnectionTtl(), hashedWheelTimer);
    }

    private ChannelId channelId(Channel channel) {
        return Channels.getChannelId(channel);
    }

    public DefaultChannelPool(int maxIdleTime, int connectionTtl, Timer nettyTimer) {
        this.maxIdleTime = maxIdleTime;
        this.connectionTtl = connectionTtl;
        this.connectionTtlEnabled = connectionTtl > 0;
        this.channelId2Creation = this.connectionTtlEnabled ? new ConcurrentHashMap() : null;
        this.nettyTimer = nettyTimer;
        this.maxIdleTimeEnabled = maxIdleTime > 0;
        this.cleanerPeriod = Math.min(this.connectionTtlEnabled ? (long)connectionTtl : Integer.MAX_VALUE, this.maxIdleTimeEnabled ? (long)maxIdleTime : Long.MAX_VALUE);
        if (this.connectionTtlEnabled || this.maxIdleTimeEnabled) {
            this.scheduleNewIdleChannelDetector(new IdleChannelDetector());
        }
    }

    private void scheduleNewIdleChannelDetector(TimerTask task) {
        this.nettyTimer.newTimeout(task, this.cleanerPeriod, TimeUnit.MILLISECONDS);
    }

    private boolean isTtlExpired(Channel channel, long now) {
        if (!this.connectionTtlEnabled) {
            return false;
        }
        ChannelCreation creation = this.channelId2Creation.get(this.channelId(channel));
        return creation != null && now - creation.creationTime >= (long)this.connectionTtl;
    }

    private boolean isRemotelyClosed(Channel channel) {
        return !channel.isActive();
    }

    @Override
    public boolean offer(Channel channel, Object partitionKey) {
        if (this.isClosed.get()) {
            return false;
        }
        long now = DateUtils.millisTime();
        if (this.isTtlExpired(channel, now)) {
            return false;
        }
        boolean offered = this.offer0(channel, partitionKey, now);
        if (this.connectionTtlEnabled && offered) {
            this.registerChannelCreation(channel, partitionKey, now);
        }
        return offered;
    }

    private boolean offer0(Channel channel, Object partitionKey, long now) {
        ConcurrentLinkedDeque partition = this.partitions.get(partitionKey);
        if (partition == null) {
            partition = this.partitions.computeIfAbsent(partitionKey, pk -> new ConcurrentLinkedDeque());
        }
        return partition.offerFirst(new IdleChannel(channel, now));
    }

    private void registerChannelCreation(Channel channel, Object partitionKey, long now) {
        if (this.channelId2Creation.containsKey(partitionKey)) {
            this.channelId2Creation.putIfAbsent(this.channelId(channel), new ChannelCreation(now, partitionKey));
        }
    }

    @Override
    public Channel poll(Object partitionKey) {
        IdleChannel idleChannel = null;
        ConcurrentLinkedDeque<IdleChannel> partition = this.partitions.get(partitionKey);
        if (partition != null) {
            while (idleChannel == null && (idleChannel = partition.pollFirst()) != null) {
                if (!this.isRemotelyClosed(idleChannel.channel)) continue;
                idleChannel = null;
                LOGGER.trace("Channel not connected or not opened, probably remotely closed!");
            }
        }
        return idleChannel != null ? idleChannel.channel : null;
    }

    @Override
    public boolean removeAll(Channel channel) {
        ChannelCreation creation = this.connectionTtlEnabled ? this.channelId2Creation.remove(this.channelId(channel)) : null;
        return !this.isClosed.get() && creation != null && this.partitions.get(creation.partitionKey).remove(channel);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed.get();
    }

    @Override
    public void destroy() {
        if (this.isClosed.getAndSet(true)) {
            return;
        }
        for (ConcurrentLinkedDeque<IdleChannel> partition : this.partitions.values()) {
            for (IdleChannel idleChannel : partition) {
                this.close(idleChannel.channel);
            }
        }
        this.partitions.clear();
        if (this.connectionTtlEnabled) {
            this.channelId2Creation.clear();
        }
    }

    private void close(Channel channel) {
        Channels.setDiscard(channel);
        if (this.connectionTtlEnabled) {
            this.channelId2Creation.remove(this.channelId(channel));
        }
        Channels.silentlyCloseChannel(channel);
    }

    private void flushPartition(Object partitionKey, ConcurrentLinkedDeque<IdleChannel> partition) {
        if (partition != null) {
            this.partitions.remove(partitionKey);
            for (IdleChannel idleChannel : partition) {
                this.close(idleChannel.channel);
            }
        }
    }

    @Override
    public void flushPartition(Object partitionKey) {
        this.flushPartition(partitionKey, this.partitions.get(partitionKey));
    }

    @Override
    public void flushPartitions(ChannelPoolPartitionSelector selector) {
        for (Map.Entry<Object, ConcurrentLinkedDeque<IdleChannel>> partitionsEntry : this.partitions.entrySet()) {
            Object partitionKey = partitionsEntry.getKey();
            if (!selector.select(partitionKey)) continue;
            this.flushPartition(partitionKey, partitionsEntry.getValue());
        }
    }

    private final class IdleChannelDetector
    implements TimerTask {
        private IdleChannelDetector() {
        }

        private boolean isIdleTimeoutExpired(IdleChannel idleChannel, long now) {
            return DefaultChannelPool.this.maxIdleTimeEnabled && now - idleChannel.start >= (long)DefaultChannelPool.this.maxIdleTime;
        }

        private List<IdleChannel> expiredChannels(ConcurrentLinkedDeque<IdleChannel> partition, long now) {
            List<IdleChannel> idleTimeoutChannels = null;
            for (IdleChannel idleChannel : partition) {
                if (!this.isIdleTimeoutExpired(idleChannel, now) && !DefaultChannelPool.this.isRemotelyClosed(idleChannel.channel) && !DefaultChannelPool.this.isTtlExpired(idleChannel.channel, now)) continue;
                LOGGER.debug("Adding Candidate expired Channel {}", (Object)idleChannel.channel);
                if (idleTimeoutChannels == null) {
                    idleTimeoutChannels = new ArrayList<IdleChannel>();
                }
                idleTimeoutChannels.add(idleChannel);
            }
            return idleTimeoutChannels != null ? idleTimeoutChannels : Collections.emptyList();
        }

        private boolean isChannelCloseable(Channel channel) {
            NettyResponseFuture future;
            Object attribute = Channels.getAttribute(channel);
            if (attribute instanceof NettyResponseFuture && !(future = (NettyResponseFuture)attribute).isDone()) {
                LOGGER.error("Future not in appropriate state {}, not closing", (Object)future);
                return false;
            }
            return true;
        }

        private final List<IdleChannel> closeChannels(List<IdleChannel> candidates) {
            List<IdleChannel> closedChannels = null;
            for (int i = 0; i < candidates.size(); ++i) {
                IdleChannel idleChannel = candidates.get(i);
                if (this.isChannelCloseable(idleChannel.channel)) {
                    LOGGER.debug("Closing Idle Channel {}", (Object)idleChannel.channel);
                    DefaultChannelPool.this.close(idleChannel.channel);
                    if (closedChannels == null) continue;
                    closedChannels.add(idleChannel);
                    continue;
                }
                if (closedChannels != null) continue;
                closedChannels = new ArrayList<IdleChannel>(candidates.size());
                for (int j = 0; j < i; ++j) {
                    closedChannels.add(candidates.get(j));
                }
            }
            return closedChannels != null ? closedChannels : candidates;
        }

        public void run(Timeout timeout) throws Exception {
            if (DefaultChannelPool.this.isClosed.get()) {
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                for (Object key : DefaultChannelPool.this.partitions.keySet()) {
                    LOGGER.debug("Entry count for : {} : {}", key, (Object)((ConcurrentLinkedDeque)DefaultChannelPool.this.partitions.get(key)).size());
                }
            }
            long start = DateUtils.millisTime();
            int closedCount = 0;
            int totalCount = 0;
            for (ConcurrentLinkedDeque partition : DefaultChannelPool.this.partitions.values()) {
                List<IdleChannel> closedChannels;
                if (LOGGER.isDebugEnabled()) {
                    totalCount += partition.size();
                }
                if ((closedChannels = this.closeChannels(this.expiredChannels(partition, start))).isEmpty()) continue;
                if (DefaultChannelPool.this.connectionTtlEnabled) {
                    for (IdleChannel closedChannel : closedChannels) {
                        DefaultChannelPool.this.channelId2Creation.remove(DefaultChannelPool.this.channelId(closedChannel.channel));
                    }
                }
                partition.removeAll(closedChannels);
                closedCount += closedChannels.size();
            }
            if (LOGGER.isDebugEnabled()) {
                long duration = DateUtils.millisTime() - start;
                LOGGER.debug("Closed {} connections out of {} in {}ms", new Object[]{closedCount, totalCount, duration});
            }
            DefaultChannelPool.this.scheduleNewIdleChannelDetector(timeout.task());
        }
    }

    private static final class IdleChannel {
        final Channel channel;
        final long start;

        IdleChannel(Channel channel, long start) {
            this.channel = Assertions.assertNotNull(channel, "channel");
            this.start = start;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IdleChannel && this.channel.equals(((IdleChannel)IdleChannel.class.cast((Object)o)).channel);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }
    }

    private static final class ChannelCreation {
        final long creationTime;
        final Object partitionKey;

        ChannelCreation(long creationTime, Object partitionKey) {
            this.creationTime = creationTime;
            this.partitionKey = partitionKey;
        }
    }
}

