/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import io.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.MultipartBody;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.asynchttpclient.request.body.multipart.part.ByteArrayMultipartPart;
import org.asynchttpclient.request.body.multipart.part.FileMultipartPart;
import org.asynchttpclient.request.body.multipart.part.MessageEndMultipartPart;
import org.asynchttpclient.request.body.multipart.part.MultipartPart;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;

public class MultipartUtils {
    private static byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    public static MultipartBody newMultipartBody(List<Part> parts, HttpHeaders requestHeaders) {
        byte[] boundary;
        String contentType;
        Assertions.assertNotNull(parts, "parts");
        String contentTypeHeader = requestHeaders.get("Content-Type");
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                contentType = contentTypeHeader;
                boundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                boundary = MultipartUtils.generateBoundary();
                contentType = MultipartUtils.computeContentType(contentTypeHeader, boundary);
            }
        } else {
            boundary = MultipartUtils.generateBoundary();
            contentType = MultipartUtils.computeContentType("multipart/form-data", boundary);
        }
        List<MultipartPart<? extends Part>> multipartParts = MultipartUtils.generateMultipartParts(parts, boundary);
        return new MultipartBody(multipartParts, contentType, boundary);
    }

    public static List<MultipartPart<? extends Part>> generateMultipartParts(List<Part> parts, byte[] boundary) {
        ArrayList<MultipartPart<? extends Part>> multipartParts = new ArrayList<MultipartPart<? extends Part>>(parts.size());
        for (Part part : parts) {
            if (part instanceof FilePart) {
                multipartParts.add(new FileMultipartPart((FilePart)part, boundary));
                continue;
            }
            if (part instanceof ByteArrayPart) {
                multipartParts.add(new ByteArrayMultipartPart((ByteArrayPart)part, boundary));
                continue;
            }
            if (part instanceof StringPart) {
                StringPart stringPart = (StringPart)part;
                byte[] bytes = stringPart.getValue().getBytes(stringPart.getCharset());
                ByteArrayPart byteArrayPart = new ByteArrayPart(stringPart.getName(), bytes, stringPart.getContentType(), stringPart.getCharset(), null, stringPart.getContentId(), stringPart.getTransferEncoding());
                byteArrayPart.setCustomHeaders(stringPart.getCustomHeaders());
                multipartParts.add(new ByteArrayMultipartPart(byteArrayPart, boundary));
                continue;
            }
            throw new IllegalArgumentException("Unknown part type: " + part);
        }
        multipartParts.add(new MessageEndMultipartPart(boundary));
        return multipartParts;
    }

    private static byte[] generateBoundary() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    private static String computeContentType(String base, byte[] boundary) {
        StringBuilder buffer = StringUtils.stringBuilder().append(base);
        if (!base.endsWith(";")) {
            buffer.append(';');
        }
        return buffer.append(" boundary=").append(new String(boundary, StandardCharsets.US_ASCII)).toString();
    }
}

