/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import io.netty.channel.Channel;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.ChannelPoolPartitioning;
import org.asynchttpclient.future.AbstractListenableFuture;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.DateUtils;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyResponseFuture<V>
extends AbstractListenableFuture<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyResponseFuture.class);
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture<?>> REDIRECT_COUNT_UPDATER = PlatformDependent.newAtomicIntegerFieldUpdater(NettyResponseFuture.class, "redirectCount");
    private static final AtomicIntegerFieldUpdater<NettyResponseFuture<?>> CURRENT_RETRY_UPDATER = PlatformDependent.newAtomicIntegerFieldUpdater(NettyResponseFuture.class, "currentRetry");
    private static final AtomicReferenceFieldUpdater<NettyResponseFuture, Object> CONTENT_UPDATER = PlatformDependent.newAtomicReferenceFieldUpdater(NettyResponseFuture.class, "content");
    private static final AtomicReferenceFieldUpdater<NettyResponseFuture, ExecutionException> EX_EX_UPDATER = PlatformDependent.newAtomicReferenceFieldUpdater(NettyResponseFuture.class, "exEx");
    private final long start = DateUtils.millisTime();
    private final ChannelPoolPartitioning connectionPoolPartitioning;
    private final ProxyServer proxyServer;
    private final int maxRetry;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicBoolean inAuth = new AtomicBoolean(false);
    private final AtomicBoolean inProxyAuth = new AtomicBoolean(false);
    private final AtomicBoolean statusReceived = new AtomicBoolean(false);
    private final AtomicBoolean contentProcessed = new AtomicBoolean(false);
    private final AtomicBoolean onThrowableCalled = new AtomicBoolean(false);
    private volatile int redirectCount = 0;
    private volatile int currentRetry = 0;
    private volatile V content;
    private volatile ExecutionException exEx;
    private volatile long touch = DateUtils.millisTime();
    private volatile TimeoutsHolder timeoutsHolder;
    private volatile ChannelState channelState = ChannelState.NEW;
    private Channel channel;
    private boolean keepAlive = true;
    private Request targetRequest;
    private Request currentRequest;
    private NettyRequest nettyRequest;
    private AsyncHandler<V> asyncHandler;
    private boolean streamWasAlreadyConsumed;
    private boolean reuseChannel;
    private boolean headersAlreadyWrittenOnContinue;
    private boolean dontWriteBodyBecauseExpectContinue;
    private boolean allowConnect;
    private Realm realm;
    private Realm proxyRealm;
    public Throwable pendingException;

    public NettyResponseFuture(Request originalRequest, AsyncHandler<V> asyncHandler, NettyRequest nettyRequest, int maxRetry, ChannelPoolPartitioning connectionPoolPartitioning, ProxyServer proxyServer) {
        this.asyncHandler = asyncHandler;
        this.targetRequest = this.currentRequest = originalRequest;
        this.nettyRequest = nettyRequest;
        this.connectionPoolPartitioning = connectionPoolPartitioning;
        this.proxyServer = proxyServer;
        this.maxRetry = maxRetry;
    }

    @Override
    public boolean isDone() {
        return this.isDone.get() || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    @Override
    public boolean cancel(boolean force) {
        this.cancelTimeouts();
        if (this.isCancelled.getAndSet(true)) {
            return false;
        }
        if (this.channel != null) {
            Channels.setDiscard(this.channel);
            Channels.silentlyCloseChannel(this.channel);
        }
        if (!this.onThrowableCalled.getAndSet(true)) {
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable t) {
                LOGGER.warn("cancel", t);
            }
        }
        this.latch.countDown();
        this.runListeners();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.getContent();
    }

    @Override
    public V get(long l, TimeUnit tu) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(l, tu)) {
            throw new TimeoutException();
        }
        return this.getContent();
    }

    private V getContent() throws ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        ExecutionException e = EX_EX_UPDATER.get(this);
        if (e != null) {
            throw e;
        }
        Object update = CONTENT_UPDATER.get(this);
        CURRENT_RETRY_UPDATER.set(this, this.maxRetry);
        if (!this.contentProcessed.getAndSet(true)) {
            block9: {
                try {
                    update = this.asyncHandler.onCompleted();
                }
                catch (Throwable ex) {
                    if (this.onThrowableCalled.getAndSet(true)) break block9;
                    try {
                        try {
                            this.asyncHandler.onThrowable(ex);
                        }
                        catch (Throwable t) {
                            LOGGER.debug("asyncHandler.onThrowable", t);
                        }
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        this.cancelTimeouts();
                        throw throwable;
                    }
                }
            }
            CONTENT_UPDATER.compareAndSet(this, null, update);
        }
        return (V)update;
    }

    private boolean terminateAndExit() {
        this.cancelTimeouts();
        this.channel = null;
        this.reuseChannel = false;
        return this.isDone.getAndSet(true) || this.isCancelled.get();
    }

    @Override
    public final void done() {
        if (this.terminateAndExit()) {
            return;
        }
        try {
            this.getContent();
        }
        catch (ExecutionException t) {
            return;
        }
        catch (RuntimeException t) {
            EX_EX_UPDATER.compareAndSet(this, null, new ExecutionException(MiscUtils.getCause(t)));
        }
        finally {
            this.latch.countDown();
        }
        this.runListeners();
    }

    @Override
    public final void abort(Throwable t) {
        EX_EX_UPDATER.compareAndSet(this, null, new ExecutionException(t));
        if (this.terminateAndExit()) {
            return;
        }
        if (this.onThrowableCalled.compareAndSet(false, true)) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable te) {
                LOGGER.debug("asyncHandler.onThrowable", te);
            }
        }
        this.latch.countDown();
        this.runListeners();
    }

    @Override
    public void touch() {
        this.touch = DateUtils.millisTime();
    }

    @Override
    public CompletableFuture<V> toCompletableFuture() {
        final CompletableFuture completable = new CompletableFuture();
        this.addListener(new Runnable(){

            @Override
            public void run() {
                ExecutionException e = (ExecutionException)EX_EX_UPDATER.get(NettyResponseFuture.this);
                if (e != null) {
                    completable.completeExceptionally(e);
                } else {
                    completable.complete(CONTENT_UPDATER.get(NettyResponseFuture.this));
                }
            }
        }, new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
        return completable;
    }

    public Uri getUri() {
        return this.targetRequest.getUri();
    }

    public ChannelPoolPartitioning getConnectionPoolPartitioning() {
        return this.connectionPoolPartitioning;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public void setAsyncHandler(AsyncHandler<V> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public void cancelTimeouts() {
        if (this.timeoutsHolder != null) {
            this.timeoutsHolder.cancel();
            this.timeoutsHolder = null;
        }
    }

    public final Request getTargetRequest() {
        return this.targetRequest;
    }

    public final Request getCurrentRequest() {
        return this.currentRequest;
    }

    public final NettyRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public final void setNettyRequest(NettyRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    public final AsyncHandler<V> getAsyncHandler() {
        return this.asyncHandler;
    }

    public final boolean isKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int incrementAndGetCurrentRedirectCount() {
        return REDIRECT_COUNT_UPDATER.incrementAndGet(this);
    }

    public void setTimeoutsHolder(TimeoutsHolder timeoutsHolder) {
        this.timeoutsHolder = timeoutsHolder;
    }

    public TimeoutsHolder getTimeoutsHolder() {
        return this.timeoutsHolder;
    }

    public AtomicBoolean getInAuth() {
        return this.inAuth;
    }

    public AtomicBoolean getInProxyAuth() {
        return this.inProxyAuth;
    }

    public ChannelState getChannelState() {
        return this.channelState;
    }

    public void setChannelState(ChannelState channelState) {
        this.channelState = channelState;
    }

    public boolean getAndSetStatusReceived(boolean sr) {
        return this.statusReceived.getAndSet(sr);
    }

    public boolean isStreamWasAlreadyConsumed() {
        return this.streamWasAlreadyConsumed;
    }

    public void setStreamWasAlreadyConsumed(boolean streamWasAlreadyConsumed) {
        this.streamWasAlreadyConsumed = streamWasAlreadyConsumed;
    }

    public long getLastTouch() {
        return this.touch;
    }

    public void setHeadersAlreadyWrittenOnContinue(boolean headersAlreadyWrittenOnContinue) {
        this.headersAlreadyWrittenOnContinue = headersAlreadyWrittenOnContinue;
    }

    public boolean isHeadersAlreadyWrittenOnContinue() {
        return this.headersAlreadyWrittenOnContinue;
    }

    public void setDontWriteBodyBecauseExpectContinue(boolean dontWriteBodyBecauseExpectContinue) {
        this.dontWriteBodyBecauseExpectContinue = dontWriteBodyBecauseExpectContinue;
    }

    public boolean isDontWriteBodyBecauseExpectContinue() {
        return this.dontWriteBodyBecauseExpectContinue;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public boolean isConnectAllowed() {
        return this.allowConnect;
    }

    public void setConnectAllowed(boolean allowConnect) {
        this.allowConnect = allowConnect;
    }

    public void attachChannel(Channel channel, boolean reuseChannel) {
        if (this.isDone()) {
            Channels.silentlyCloseChannel(channel);
        }
        this.channel = channel;
        this.reuseChannel = reuseChannel;
    }

    public Channel channel() {
        return this.channel;
    }

    public boolean reuseChannel() {
        return this.reuseChannel;
    }

    public boolean canRetry() {
        return this.maxRetry > 0 && CURRENT_RETRY_UPDATER.incrementAndGet(this) <= this.maxRetry;
    }

    public void setTargetRequest(Request targetRequest) {
        this.targetRequest = targetRequest;
    }

    public void setCurrentRequest(Request currentRequest) {
        this.currentRequest = currentRequest;
    }

    public boolean canBeReplayed() {
        return !this.isDone() && this.canRetry() && (!Channels.isChannelValid(this.channel) || this.getUri().getScheme().equalsIgnoreCase("https")) && !this.inAuth.get() && !this.inProxyAuth.get();
    }

    public long getStart() {
        return this.start;
    }

    public Object getPartitionKey() {
        return this.connectionPoolPartitioning.getPartitionKey(this.targetRequest.getUri(), this.targetRequest.getVirtualHost(), this.proxyServer);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public Realm getProxyRealm() {
        return this.proxyRealm;
    }

    public void setProxyRealm(Realm proxyRealm) {
        this.proxyRealm = proxyRealm;
    }

    public String toString() {
        return "NettyResponseFuture{currentRetry=" + this.currentRetry + ",\n\tisDone=" + this.isDone + ",\n\tisCancelled=" + this.isCancelled + ",\n\tasyncHandler=" + this.asyncHandler + ",\n\tnettyRequest=" + this.nettyRequest + ",\n\tcontent=" + this.content + ",\n\turi=" + this.getUri() + ",\n\tkeepAlive=" + this.keepAlive + ",\n\texEx=" + this.exEx + ",\n\tredirectCount=" + this.redirectCount + ",\n\ttimeoutsHolder=" + this.timeoutsHolder + ",\n\tinAuth=" + this.inAuth + ",\n\tstatusReceived=" + this.statusReceived + ",\n\ttouch=" + this.touch + '}';
    }
}

