/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.netty.NettyResponse;
import org.asynchttpclient.uri.Uri;

public interface Response {
    public int getStatusCode();

    public String getStatusText();

    public byte[] getResponseBodyAsBytes();

    public ByteBuffer getResponseBodyAsByteBuffer();

    public InputStream getResponseBodyAsStream();

    public String getResponseBody(Charset var1);

    public String getResponseBody();

    public Uri getUri();

    public String getContentType();

    public String getHeader(String var1);

    public List<String> getHeaders(String var1);

    public HttpHeaders getHeaders();

    public boolean isRedirected();

    public String toString();

    public List<Cookie> getCookies();

    public boolean hasResponseStatus();

    public boolean hasResponseHeaders();

    public boolean hasResponseBody();

    public SocketAddress getRemoteAddress();

    public SocketAddress getLocalAddress();

    public static class ResponseBuilder {
        private final List<HttpResponseBodyPart> bodyParts = new ArrayList<HttpResponseBodyPart>();
        private HttpResponseStatus status;
        private HttpResponseHeaders headers;

        public ResponseBuilder accumulate(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public ResponseBuilder accumulate(HttpResponseHeaders headers) {
            this.headers = this.headers == null ? headers : new HttpResponseHeaders(this.headers.getHeaders().add(headers.getHeaders()), true);
            return this;
        }

        public ResponseBuilder accumulate(HttpResponseBodyPart bodyPart) {
            if (bodyPart.length() > 0) {
                this.bodyParts.add(bodyPart);
            }
            return this;
        }

        public Response build() {
            return this.status == null ? null : new NettyResponse(this.status, this.headers, this.bodyParts);
        }

        public void reset() {
            this.bodyParts.clear();
            this.status = null;
            this.headers = null;
        }
    }
}

