/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.config;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.AdvancedConfig;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Realm;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyServerSelector;
import org.asynchttpclient.util.ProxyUtils;

public class AsyncHttpClientConfigBean
extends AsyncHttpClientConfig {
    public AsyncHttpClientConfigBean() {
        this.configureExecutors();
        this.configureDefaults();
        this.configureFilters();
    }

    void configureFilters() {
        this.requestFilters = new LinkedList();
        this.responseFilters = new LinkedList();
        this.ioExceptionFilters = new LinkedList();
    }

    void configureDefaults() {
        this.maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        this.maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        this.name = AsyncHttpClientConfigDefaults.defaultName();
        this.connectTimeout = AsyncHttpClientConfigDefaults.defaultConnectTimeout();
        this.webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        this.pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        this.readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        this.requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        this.connectionTTL = AsyncHttpClientConfigDefaults.defaultConnectionTTL();
        this.followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        this.maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        this.compressionEnforced = AsyncHttpClientConfigDefaults.defaultCompressionEnforced();
        this.userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        this.allowPoolingConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnections();
        this.maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        this.ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        this.allowPoolingSslConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingSslConnections();
        this.disableUrlEncodingForBoundRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        this.strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        this.acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        this.sslSessionCacheSize = AsyncHttpClientConfigDefaults.defaultSslSessionCacheSize();
        this.sslSessionTimeout = AsyncHttpClientConfigDefaults.defaultSslSessionTimeout();
        if (AsyncHttpClientConfigDefaults.defaultUseProxySelector()) {
            this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
        } else if (AsyncHttpClientConfigDefaults.defaultUseProxyProperties()) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
        }
    }

    void configureExecutors() {
        this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AsyncHttpClient-Callback");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public AsyncHttpClientConfigBean setName(String name) {
        this.name = name;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxTotalConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        return this;
    }

    public AsyncHttpClientConfigBean setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setConnectionTTL(int connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public AsyncHttpClientConfigBean setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
        this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public AsyncHttpClientConfigBean setStrict302Handling(boolean strict302Handling) {
        this.strict302Handling = strict302Handling;
        return this;
    }

    public AsyncHttpClientConfigBean setCompressionEnforced(boolean compressionEnforced) {
        this.compressionEnforced = compressionEnforced;
        return this;
    }

    public AsyncHttpClientConfigBean setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowPoolingConnections(boolean allowPoolingConnections) {
        this.allowPoolingConnections = allowPoolingConnections;
        return this;
    }

    public AsyncHttpClientConfigBean setApplicationThreadPool(ExecutorService applicationThreadPool) {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = applicationThreadPool;
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServer(ProxyServer proxyServer) {
        this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
        this.proxyServerSelector = proxyServerSelector;
        return this;
    }

    public AsyncHttpClientConfigBean setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public AsyncHttpClientConfigBean setAdvancedConfig(AdvancedConfig advancedConfig) {
        this.advancedConfig = advancedConfig;
        return this;
    }

    public AsyncHttpClientConfigBean setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public AsyncHttpClientConfigBean addRequestFilter(RequestFilter requestFilter) {
        this.requestFilters.add(requestFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addResponseFilters(ResponseFilter responseFilter) {
        this.responseFilters.add(responseFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addIoExceptionFilters(IOExceptionFilter ioExceptionFilter) {
        this.ioExceptionFilters.add(ioExceptionFilter);
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRequestRetry(int maxRequestRetry) {
        this.maxRequestRetry = maxRequestRetry;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowPoolingSslConnections(boolean allowPoolingSslConnections) {
        this.allowPoolingSslConnections = allowPoolingSslConnections;
        return this;
    }

    public AsyncHttpClientConfigBean setDisableUrlEncodingForBoundRequests(boolean disableUrlEncodingForBoundRequests) {
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
        return this;
    }

    public AsyncHttpClientConfigBean setIoThreadMultiplier(int ioThreadMultiplier) {
        this.ioThreadMultiplier = ioThreadMultiplier;
        return this;
    }

    public AsyncHttpClientConfigBean setAcceptAnyCertificate(boolean acceptAnyCertificate) {
        this.acceptAnyCertificate = acceptAnyCertificate;
        return this;
    }

    public AsyncHttpClientConfigBean setSslSessionCacheSize(Integer sslSessionCacheSize) {
        this.sslSessionCacheSize = sslSessionCacheSize;
        return this;
    }

    public AsyncHttpClientConfigBean setSslSessionTimeout(Integer sslSessionTimeout) {
        this.sslSessionTimeout = sslSessionTimeout;
        return this;
    }
}

