/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.ChannelConnector;
import org.asynchttpclient.proxy.ProxyServer;

public class NettyChannelConnector
extends ChannelConnector {
    public NettyChannelConnector(Request request, ProxyServer proxy, boolean useProxy, AsyncHandler<?> asyncHandler) throws UnknownHostException {
        super(request, proxy, useProxy, asyncHandler);
    }

    public void connect(final Bootstrap bootstrap, final ChannelFutureListener listener) throws UnknownHostException {
        final InetSocketAddress remoteAddress = this.remoteAddresses[this.i];
        ChannelFuture future = this.localAddress != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)this.localAddress) : bootstrap.connect((SocketAddress)remoteAddress);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean retry = false;
                if (future.isSuccess()) {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionSuccess(future.channel(), remoteAddress.getAddress());
                    }
                } else {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionFailure(remoteAddress.getAddress());
                    }
                    retry = NettyChannelConnector.this.pickNextRemoteAddress();
                }
                if (retry) {
                    NettyChannelConnector.this.connect(bootstrap, listener);
                } else {
                    listener.operationComplete((Future)future);
                }
            }
        });
    }
}

