/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InputStreamBodyGenerator
implements BodyGenerator {
    private static final byte[] END_PADDING = "\r\n".getBytes();
    private static final byte[] ZERO = "0".getBytes();
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamBody.class);
    private final InputStream inputStream;
    private boolean patchNetty3ChunkingIssue = false;

    public InputStreamBodyGenerator(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public Body createBody() {
        return new InputStreamBody(this.inputStream);
    }

    public void patchNetty3ChunkingIssue(boolean patchNetty3ChunkingIssue) {
        this.patchNetty3ChunkingIssue = patchNetty3ChunkingIssue;
    }

    private class InputStreamBody
    implements Body {
        private final InputStream inputStream;
        private boolean eof = false;
        private int endDataCount = 0;
        private byte[] chunk;

        private InputStreamBody(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.State read(ByteBuffer buffer) throws IOException {
            this.chunk = new byte[buffer.remaining() - 10];
            int read = -1;
            boolean write = false;
            try {
                read = this.inputStream.read(this.chunk);
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to read", (Throwable)ex);
            }
            if (InputStreamBodyGenerator.this.patchNetty3ChunkingIssue) {
                if (read >= 0) {
                    buffer.put(Integer.toHexString(read).getBytes());
                    buffer.put(END_PADDING);
                    buffer.put(this.chunk, 0, read);
                    buffer.put(END_PADDING);
                    write = true;
                } else if (!this.eof) {
                    ++this.endDataCount;
                    if (this.endDataCount == 1) {
                        buffer.put(ZERO);
                    } else if (this.endDataCount == 2) {
                        this.eof = true;
                    }
                    buffer.put(END_PADDING);
                    write = true;
                }
            } else if (read > 0) {
                buffer.put(this.chunk, 0, read);
                write = true;
            }
            return write ? Body.State.Continue : Body.State.Stop;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

