/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.asynchttpclient.FluentCaseInsensitiveStringsMap;
import org.asynchttpclient.request.body.multipart.MultipartBody;
import org.asynchttpclient.request.body.multipart.OutputStreamPartVisitor;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartUtils.class);
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    private MultipartUtils() {
    }

    public static MultipartBody newMultipartBody(List<Part> parts, FluentCaseInsensitiveStringsMap requestHeaders) {
        byte[] multipartBoundary;
        String contentType;
        if (parts == null) {
            throw new NullPointerException("parts");
        }
        String contentTypeHeader = requestHeaders.getFirstValue("Content-Type");
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                contentType = contentTypeHeader;
                multipartBoundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                multipartBoundary = MultipartUtils.generateMultipartBoundary();
                contentType = MultipartUtils.computeContentType(contentTypeHeader, multipartBoundary);
            }
        } else {
            multipartBoundary = MultipartUtils.generateMultipartBoundary();
            contentType = MultipartUtils.computeContentType(MULTIPART_FORM_CONTENT_TYPE, multipartBoundary);
        }
        long contentLength = MultipartUtils.getLengthOfParts(parts, multipartBoundary);
        return new MultipartBody(parts, contentType, contentLength, multipartBoundary);
    }

    private static byte[] generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    private static String computeContentType(String base, byte[] multipartBoundary) {
        StringBuilder buffer = StringUtils.stringBuilder().append(base);
        if (!base.endsWith(";")) {
            buffer.append(';');
        }
        return buffer.append(" boundary=").append(new String(multipartBoundary, StandardCharsets.US_ASCII)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeBytesToChannel(WritableByteChannel target, byte[] bytes) throws IOException {
        int written = 0;
        int maxSpin = 0;
        ByteBuffer message = ByteBuffer.wrap(bytes);
        if (target instanceof SocketChannel) {
            try (Selector selector = Selector.open();){
                SocketChannel channel = (SocketChannel)target;
                channel.register(selector, 4);
                while (written < bytes.length) {
                    selector.select(1000L);
                    ++maxSpin;
                    Set<SelectionKey> selectedKeys = selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        if (!key.isWritable()) continue;
                        written += target.write(message);
                        maxSpin = 0;
                    }
                    if (maxSpin < 10) continue;
                    throw new IOException("Unable to write on channel " + target);
                }
            }
        } else {
            while (target.isOpen() && written < bytes.length) {
                long nWrite = target.write(message);
                written = (int)((long)written + nWrite);
                if (nWrite == 0L && maxSpin++ < 10) {
                    LOGGER.info("Waiting for writing...");
                    try {
                        bytes.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.trace(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                if (maxSpin >= 10) {
                    throw new IOException("Unable to write on channel " + target);
                }
                maxSpin = 0;
            }
        }
        return written;
    }

    public static byte[] getMessageEnd(byte[] partBoundary) throws IOException {
        if (!MiscUtils.isNonEmpty(partBoundary)) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(out);
        visitor.withBytes(Part.EXTRA_BYTES);
        visitor.withBytes(partBoundary);
        visitor.withBytes(Part.EXTRA_BYTES);
        visitor.withBytes(Part.CRLF_BYTES);
        return out.toByteArray();
    }

    public static long getLengthOfParts(List<Part> parts, byte[] partBoundary) {
        try {
            if (parts == null) {
                throw new NullPointerException("parts");
            }
            long total = 0L;
            for (Part part : parts) {
                long l = part.length(partBoundary);
                if (l < 0L) {
                    return -1L;
                }
                total += l;
            }
            total += (long)Part.EXTRA_BYTES.length;
            total += (long)partBoundary.length;
            total += (long)Part.EXTRA_BYTES.length;
            return total += (long)Part.CRLF_BYTES.length;
        }
        catch (Exception e) {
            LOGGER.error("An exception occurred while getting the length of the parts", (Throwable)e);
            return 0L;
        }
    }
}

