/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.simple.consumer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.simple.consumer.BodyConsumer;

public class AppendableBodyConsumer
implements BodyConsumer {
    private final Appendable appendable;
    private final Charset charset;

    public AppendableBodyConsumer(Appendable appendable, Charset charset) {
        this.appendable = appendable;
        this.charset = charset;
    }

    public AppendableBodyConsumer(Appendable appendable) {
        this.appendable = appendable;
        this.charset = StandardCharsets.UTF_8;
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        this.appendable.append(new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), this.charset));
    }

    @Override
    public void close() throws IOException {
        if (this.appendable instanceof Closeable) {
            ((Closeable)Closeable.class.cast(this.appendable)).close();
        }
    }
}

