/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.ntlm.NtlmEngine;
import org.asynchttpclient.ntlm.NtlmUtils;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.spnego.SpnegoEngine;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Base64;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.StringUtils;

public final class AuthenticatorUtils {
    private static final String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";

    public static String computeBasicAuthentication(Realm realm) {
        return AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset());
    }

    public static String computeBasicAuthentication(ProxyServer proxyServer) {
        return AuthenticatorUtils.computeBasicAuthentication(proxyServer.getPrincipal(), proxyServer.getPassword(), proxyServer.getCharset());
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s = principal + ":" + password;
        return "Basic " + Base64.encode(s.getBytes(charset));
    }

    public static String computeRealmURI(Realm realm) {
        return AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path = HttpUtils.getNonEmptyPath(uri);
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path : path + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm) {
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", AuthenticatorUtils.computeRealmURI(realm), true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static StringBuilder append(StringBuilder builder, String name, String value, boolean quoted) {
        builder.append(name).append('=');
        if (quoted) {
            builder.append('\"').append(value).append('\"');
        } else {
            builder.append(value);
        }
        return builder.append(", ");
    }

    private static List<String> getProxyAuthorizationHeader(Request request) {
        return request.getHeaders().get(PROXY_AUTHORIZATION_HEADER);
    }

    public static String perConnectionProxyAuthorizationHeader(Request request, ProxyServer proxyServer, boolean connect) {
        List<String> auth;
        String proxyAuthorization = null;
        if (connect) {
            List<String> auth2 = AuthenticatorUtils.getProxyAuthorizationHeader(request);
            String ntlmHeader = NtlmUtils.getNTLM(auth2);
            if (ntlmHeader != null) {
                proxyAuthorization = ntlmHeader;
            }
        } else if (proxyServer != null && proxyServer.getPrincipal() != null && proxyServer.getScheme().isLikeNtlm() && NtlmUtils.getNTLM(auth = AuthenticatorUtils.getProxyAuthorizationHeader(request)) == null) {
            String msg = NtlmEngine.INSTANCE.generateType1Msg();
            proxyAuthorization = "NTLM " + msg;
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Request request, ProxyServer proxyServer, Realm realm, boolean connect) {
        String proxyAuthorization = null;
        if (!connect && proxyServer != null && proxyServer.getScheme() == Realm.AuthScheme.BASIC) {
            proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyServer);
        } else if (realm != null && realm.getUsePreemptiveAuth() && realm.isTargetProxy()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: 
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perConnectionAuthorizationHeader(Request request, ProxyServer proxyServer, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request.getVirtualHost() != null ? request.getVirtualHost() : request.getUri().getHost());
                    authorizationHeader = "Negotiate " + SpnegoEngine.instance().generateToken(host);
                    break;
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Request request, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.getUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: 
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }
}

