/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.util.Timer;
import java.util.HashMap;
import java.util.Map;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.channel.pool.ConnectionStrategy;
import org.asynchttpclient.netty.EagerNettyResponseBodyPart;
import org.asynchttpclient.netty.LazyNettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.handler.DefaultConnectionStrategy;
import org.asynchttpclient.netty.ws.NettyWebSocket;

public class AdvancedConfig {
    private final Map<ChannelOption<Object>, Object> channelOptions;
    private final EventLoopGroup eventLoopGroup;
    private final boolean preferNative;
    private final AdditionalPipelineInitializer httpAdditionalPipelineInitializer;
    private final AdditionalPipelineInitializer wsAdditionalPipelineInitializer;
    private final ResponseBodyPartFactory responseBodyPartFactory;
    private final ChannelPool channelPool;
    private final Timer nettyTimer;
    private final NettyWebSocketFactory nettyWebSocketFactory;
    private final ConnectionStrategy connectionStrategy;

    public AdvancedConfig(Map<ChannelOption<Object>, Object> channelOptions, EventLoopGroup eventLoopGroup, boolean preferNative, AdditionalPipelineInitializer httpAdditionalPipelineInitializer, AdditionalPipelineInitializer wsAdditionalPipelineInitializer, ResponseBodyPartFactory responseBodyPartFactory, ChannelPool channelPool, Timer nettyTimer, NettyWebSocketFactory nettyWebSocketFactory, ConnectionStrategy connectionStrategy) {
        if (responseBodyPartFactory == null) {
            throw new NullPointerException("responseBodyPartFactory");
        }
        if (nettyWebSocketFactory == null) {
            throw new NullPointerException("nettyWebSocketFactory");
        }
        if (connectionStrategy == null) {
            throw new NullPointerException("connectionStrategy");
        }
        this.channelOptions = channelOptions;
        this.eventLoopGroup = eventLoopGroup;
        this.preferNative = preferNative;
        this.httpAdditionalPipelineInitializer = httpAdditionalPipelineInitializer;
        this.wsAdditionalPipelineInitializer = wsAdditionalPipelineInitializer;
        this.responseBodyPartFactory = responseBodyPartFactory;
        this.channelPool = channelPool;
        this.nettyTimer = nettyTimer;
        this.nettyWebSocketFactory = nettyWebSocketFactory;
        this.connectionStrategy = connectionStrategy;
    }

    public Map<ChannelOption<Object>, Object> getChannelOptions() {
        return this.channelOptions;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public boolean isPreferNative() {
        return this.preferNative;
    }

    public AdditionalPipelineInitializer getHttpAdditionalPipelineInitializer() {
        return this.httpAdditionalPipelineInitializer;
    }

    public AdditionalPipelineInitializer getWsAdditionalPipelineInitializer() {
        return this.wsAdditionalPipelineInitializer;
    }

    public ResponseBodyPartFactory getResponseBodyPartFactory() {
        return this.responseBodyPartFactory;
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    public Timer getNettyTimer() {
        return this.nettyTimer;
    }

    public NettyWebSocketFactory getNettyWebSocketFactory() {
        return this.nettyWebSocketFactory;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public static class DefaultNettyWebSocketFactory
    implements NettyWebSocketFactory {
        @Override
        public NettyWebSocket newNettyWebSocket(Channel channel, AsyncHttpClientConfig config) {
            return new NettyWebSocket(channel, config);
        }
    }

    public static interface NettyWebSocketFactory {
        public NettyWebSocket newNettyWebSocket(Channel var1, AsyncHttpClientConfig var2);
    }

    public static class LazyResponseBodyPartFactory
    implements ResponseBodyPartFactory {
        @Override
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
            return new LazyNettyResponseBodyPart(buf, last);
        }
    }

    public static class EagerResponseBodyPartFactory
    implements ResponseBodyPartFactory {
        @Override
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
            return new EagerNettyResponseBodyPart(buf, last);
        }
    }

    public static interface ResponseBodyPartFactory {
        public NettyResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }

    public static interface AdditionalPipelineInitializer {
        public void initPipeline(ChannelPipeline var1) throws Exception;
    }

    public static class Builder {
        private Map<ChannelOption<Object>, Object> channelOptions = new HashMap<ChannelOption<Object>, Object>();
        private EventLoopGroup eventLoopGroup;
        private boolean preferNative;
        private AdditionalPipelineInitializer httpAdditionalPipelineInitializer;
        private AdditionalPipelineInitializer wsAdditionalPipelineInitializer;
        private ResponseBodyPartFactory responseBodyPartFactory = new EagerResponseBodyPartFactory();
        private ChannelPool channelPool;
        private Timer nettyTimer;
        private NettyWebSocketFactory nettyWebSocketFactory = new DefaultNettyWebSocketFactory();
        private ConnectionStrategy connectionStrategy = new DefaultConnectionStrategy();

        public <T> Builder addChannelOption(ChannelOption<T> name, T value) {
            this.channelOptions.put(name, value);
            return this;
        }

        public Builder setEventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public Builder setPreferNative(boolean preferNative) {
            this.preferNative = preferNative;
            return this;
        }

        public Builder setHttpAdditionalPipelineInitializer(AdditionalPipelineInitializer httpAdditionalPipelineInitializer) {
            this.httpAdditionalPipelineInitializer = httpAdditionalPipelineInitializer;
            return this;
        }

        public Builder setWsAdditionalPipelineInitializer(AdditionalPipelineInitializer wsAdditionalPipelineInitializer) {
            this.wsAdditionalPipelineInitializer = wsAdditionalPipelineInitializer;
            return this;
        }

        public Builder setResponseBodyPartFactory(ResponseBodyPartFactory responseBodyPartFactory) {
            this.responseBodyPartFactory = responseBodyPartFactory;
            return this;
        }

        public Builder setChannelPool(ChannelPool channelPool) {
            this.channelPool = channelPool;
            return this;
        }

        public Builder setNettyTimer(Timer nettyTimer) {
            this.nettyTimer = nettyTimer;
            return this;
        }

        public Builder setNettyWebSocketFactory(NettyWebSocketFactory nettyWebSocketFactory) {
            this.nettyWebSocketFactory = nettyWebSocketFactory;
            return this;
        }

        public Builder setConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.connectionStrategy = connectionStrategy;
            return this;
        }

        public AdvancedConfig build() {
            return new AdvancedConfig(this.channelOptions, this.eventLoopGroup, this.preferNative, this.httpAdditionalPipelineInitializer, this.wsAdditionalPipelineInitializer, this.responseBodyPartFactory, this.channelPool, this.nettyTimer, this.nettyWebSocketFactory, this.connectionStrategy);
        }
    }
}

