/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.nio.ByteBuffer;
import org.asynchttpclient.request.body.Body;

public class BodyChunkedInput
implements ChunkedInput<ByteBuf> {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int contentLength;
    private final int chunkSize;
    private boolean endOfInput;

    public BodyChunkedInput(Body body) {
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.body = body;
        this.contentLength = (int)body.getContentLength();
        this.chunkSize = this.contentLength <= 0 ? 8192 : Math.min(this.contentLength, 8192);
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.chunkSize);
        Body.State state = this.body.read(buffer);
        switch (state) {
            case Stop: {
                this.endOfInput = true;
                return null;
            }
            case Suspend: {
                return null;
            }
            case Continue: {
                buffer.flip();
                return Unpooled.wrappedBuffer((ByteBuffer)buffer);
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)state));
    }

    public boolean isEndOfInput() throws Exception {
        return this.endOfInput;
    }

    public void close() throws Exception {
        this.body.close();
    }
}

