/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.ws;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ws.UpgradeHandler;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;

public class WebSocketUpgradeHandler
implements UpgradeHandler<WebSocket>,
AsyncHandler<WebSocket> {
    private WebSocket webSocket;
    private final List<WebSocketListener> listeners;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private boolean onSuccessCalled;
    private int status;

    public WebSocketUpgradeHandler(List<WebSocketListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public final void onThrowable(Throwable t) {
        this.onFailure(t);
    }

    public boolean touchSuccess() {
        boolean prev = this.onSuccessCalled;
        this.onSuccessCalled = true;
        return prev;
    }

    @Override
    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.status = responseStatus.getStatusCode();
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.State.UPGRADE;
        }
        return AsyncHandler.State.ABORT;
    }

    @Override
    public final AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public final WebSocket onCompleted() throws Exception {
        if (this.status != 101) {
            IllegalStateException e = new IllegalStateException("Invalid Status Code " + this.status);
            for (WebSocketListener listener : this.listeners) {
                listener.onError(e);
            }
            throw e;
        }
        if (this.webSocket == null) {
            throw new NullPointerException("webSocket");
        }
        return this.webSocket;
    }

    @Override
    public final void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        for (WebSocketListener listener : this.listeners) {
            webSocket.addWebSocketListener(listener);
            listener.onOpen(webSocket);
        }
        this.ok.set(true);
    }

    @Override
    public final void onFailure(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            if (!this.ok.get() && this.webSocket != null) {
                this.webSocket.addWebSocketListener(listener);
            }
            listener.onError(t);
        }
    }

    public final void onClose(WebSocket webSocket, int status, String reasonPhrase) {
        if (this.webSocket == null) {
            this.webSocket = webSocket;
        }
        for (WebSocketListener listener : this.listeners) {
            if (webSocket != null) {
                webSocket.addWebSocketListener(listener);
            }
            listener.onClose(webSocket);
            if (!(listener instanceof WebSocketCloseCodeReasonListener)) continue;
            ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(listener)).onClose(webSocket, status, reasonPhrase);
        }
    }

    public static final class Builder {
        private List<WebSocketListener> listeners = new ArrayList<WebSocketListener>();

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.listeners.remove(listener);
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this.listeners);
        }
    }
}

