/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.channel.pool.ConnectionPoolPartitioning;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.netty.Callback;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.CleanupChannelGroup;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.channel.pool.DefaultChannelPool;
import org.asynchttpclient.netty.channel.pool.NoopChannelPool;
import org.asynchttpclient.netty.handler.HttpProtocol;
import org.asynchttpclient.netty.handler.Processor;
import org.asynchttpclient.netty.handler.WebSocketProtocol;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    public static final String HTTP_HANDLER = "httpHandler";
    public static final String SSL_HANDLER = "sslHandler";
    public static final String HTTP_PROCESSOR = "httpProcessor";
    public static final String WS_PROCESSOR = "wsProcessor";
    public static final String DEFLATER_HANDLER = "deflater";
    public static final String INFLATER_HANDLER = "inflater";
    public static final String CHUNKED_WRITER_HANDLER = "chunkedWriter";
    public static final String WS_DECODER_HANDLER = "ws-decoder";
    public static final String WS_FRAME_AGGREGATOR = "ws-aggregator";
    public static final String WS_ENCODER_HANDLER = "ws-encoder";
    private final AsyncHttpClientConfig config;
    private final SSLEngineFactory sslEngineFactory;
    private final EventLoopGroup eventLoopGroup;
    private final boolean allowReleaseEventLoopGroup;
    private final Class<? extends Channel> socketChannelClass;
    private final Bootstrap httpBootstrap;
    private final Bootstrap wsBootstrap;
    private final long handshakeTimeout;
    private final IOException tooManyConnections;
    private final IOException tooManyConnectionsPerHost;
    private final IOException poolAlreadyClosed;
    private final ChannelPool channelPool;
    private final boolean maxTotalConnectionsEnabled;
    private final Semaphore freeChannels;
    private final ChannelGroup openChannels;
    private final boolean maxConnectionsPerHostEnabled;
    private final ConcurrentHashMapV8<Object, Semaphore> freeChannelsPerHost;
    private final ConcurrentHashMapV8<Channel, Object> channelId2PartitionKey;
    private final ConcurrentHashMapV8.Fun<Object, Semaphore> semaphoreComputer;
    private Processor wsProcessor;

    public ChannelManager(final AsyncHttpClientConfig config, Timer nettyTimer) {
        this.config = config;
        this.sslEngineFactory = config.getSslEngineFactory() != null ? config.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(config);
        ChannelPool channelPool = config.getChannelPool();
        if (channelPool == null) {
            channelPool = config.isKeepAlive() ? new DefaultChannelPool(config, nettyTimer) : NoopChannelPool.INSTANCE;
        }
        this.channelPool = channelPool;
        this.tooManyConnections = MiscUtils.buildStaticIOException("Too many connections " + config.getMaxConnections());
        this.tooManyConnectionsPerHost = MiscUtils.buildStaticIOException("Too many connections per host " + config.getMaxConnectionsPerHost());
        this.poolAlreadyClosed = MiscUtils.buildStaticIOException("Pool is already closed");
        this.maxTotalConnectionsEnabled = config.getMaxConnections() > 0;
        boolean bl = this.maxConnectionsPerHostEnabled = config.getMaxConnectionsPerHost() > 0;
        if (this.maxTotalConnectionsEnabled || this.maxConnectionsPerHostEnabled) {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient"){

                public boolean remove(Object o) {
                    boolean removed = super.remove(o);
                    if (removed) {
                        Semaphore hostFreeChannels;
                        Object partitionKey;
                        if (ChannelManager.this.maxTotalConnectionsEnabled) {
                            ChannelManager.this.freeChannels.release();
                        }
                        if (ChannelManager.this.maxConnectionsPerHostEnabled && (partitionKey = ChannelManager.this.channelId2PartitionKey.remove(Channel.class.cast(o))) != null && (hostFreeChannels = (Semaphore)ChannelManager.this.freeChannelsPerHost.get(partitionKey)) != null) {
                            hostFreeChannels.release();
                        }
                    }
                    return removed;
                }
            };
            this.freeChannels = new Semaphore(config.getMaxConnections());
        } else {
            this.openChannels = new CleanupChannelGroup("asyncHttpClient");
            this.freeChannels = null;
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.freeChannelsPerHost = new ConcurrentHashMapV8();
            this.channelId2PartitionKey = new ConcurrentHashMapV8();
            this.semaphoreComputer = new ConcurrentHashMapV8.Fun<Object, Semaphore>(){

                public Semaphore apply(Object partitionKey) {
                    return new Semaphore(config.getMaxConnectionsPerHost());
                }
            };
        } else {
            this.freeChannelsPerHost = null;
            this.channelId2PartitionKey = null;
            this.semaphoreComputer = null;
        }
        this.handshakeTimeout = config.getHandshakeTimeout();
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName());
        boolean bl2 = this.allowReleaseEventLoopGroup = config.getEventLoopGroup() == null;
        if (this.allowReleaseEventLoopGroup) {
            if (config.isPreferNative()) {
                this.eventLoopGroup = this.newEpollEventLoopGroup(threadFactory);
                this.socketChannelClass = this.getEpollSocketChannelClass();
            } else {
                this.eventLoopGroup = new NioEventLoopGroup(0, threadFactory);
                this.socketChannelClass = NioSocketChannel.class;
            }
        } else {
            this.eventLoopGroup = config.getEventLoopGroup();
            if (this.eventLoopGroup instanceof OioEventLoopGroup) {
                throw new IllegalArgumentException("Oio is not supported");
            }
            this.socketChannelClass = this.eventLoopGroup instanceof NioEventLoopGroup ? NioSocketChannel.class : this.getEpollSocketChannelClass();
        }
        this.httpBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(this.socketChannelClass)).group(this.eventLoopGroup);
        this.wsBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(this.socketChannelClass)).group(this.eventLoopGroup);
        this.httpBootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.wsBootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        if (config.getConnectTimeout() > 0) {
            this.httpBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
            this.wsBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout());
        }
        for (Map.Entry<ChannelOption<Object>, Object> entry : config.getChannelOptions().entrySet()) {
            ChannelOption<Object> key = entry.getKey();
            Object value = entry.getValue();
            this.httpBootstrap.option(key, value);
            this.wsBootstrap.option(key, value);
        }
    }

    private EventLoopGroup newEpollEventLoopGroup(ThreadFactory threadFactory) {
        try {
            Class<?> epollEventLoopGroupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
            return (EventLoopGroup)epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class).newInstance(0, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<? extends Channel> getEpollSocketChannelClass() {
        try {
            return Class.forName("io.netty.channel.epoll.EpollSocketChannel");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void configureBootstraps(NettyRequestSender requestSender) {
        HttpProtocol httpProtocol = new HttpProtocol(this, this.config, requestSender);
        final Processor httpProcessor = new Processor(this.config, this, requestSender, httpProtocol);
        WebSocketProtocol wsProtocol = new WebSocketProtocol(this, this.config, requestSender);
        this.wsProcessor = new Processor(this.config, this, requestSender, wsProtocol);
        this.httpBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.INFLATER_HANDLER, (ChannelHandler)ChannelManager.this.newHttpContentDecompressor()).addLast(ChannelManager.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(ChannelManager.HTTP_PROCESSOR, (ChannelHandler)httpProcessor);
                ch.config().setOption(ChannelOption.AUTO_READ, (Object)false);
                if (ChannelManager.this.config.getHttpAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.config.getHttpAdditionalPipelineInitializer().initPipeline(ch.pipeline());
                }
            }
        });
        this.wsBootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(ChannelManager.HTTP_HANDLER, (ChannelHandler)ChannelManager.this.newHttpClientCodec()).addLast(ChannelManager.WS_PROCESSOR, (ChannelHandler)ChannelManager.this.wsProcessor);
                if (ChannelManager.this.config.getWsAdditionalPipelineInitializer() != null) {
                    ChannelManager.this.config.getWsAdditionalPipelineInitializer().initPipeline(ch.pipeline());
                }
            }
        });
    }

    private HttpContentDecompressor newHttpContentDecompressor() {
        if (this.config.isKeepEncodingHeader()) {
            return new HttpContentDecompressor(){

                protected String getTargetContentEncoding(String contentEncoding) throws Exception {
                    return contentEncoding;
                }
            };
        }
        return new HttpContentDecompressor();
    }

    public final void tryToOfferChannelToPool(Channel channel, AsyncHandler<?> handler, boolean keepAlive, Object partitionKey) {
        if (channel.isActive() && keepAlive) {
            LOGGER.debug("Adding key: {} for channel {}", partitionKey, (Object)channel);
            Channels.setDiscard(channel);
            if (handler instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(handler)).onConnectionOffer(channel);
            }
            this.channelPool.offer(channel, partitionKey);
            if (this.maxConnectionsPerHostEnabled) {
                this.channelId2PartitionKey.putIfAbsent((Object)channel, partitionKey);
            }
        } else {
            this.closeChannel(channel);
        }
    }

    public Channel poll(Uri uri, String virtualHost, ProxyServer proxy, ConnectionPoolPartitioning connectionPoolPartitioning) {
        Object partitionKey = connectionPoolPartitioning.getPartitionKey(uri, virtualHost, proxy);
        return this.channelPool.poll(partitionKey);
    }

    public boolean removeAll(Channel connection) {
        return this.channelPool.removeAll(connection);
    }

    private boolean tryAcquireGlobal() {
        return !this.maxTotalConnectionsEnabled || this.freeChannels.tryAcquire();
    }

    private Semaphore getFreeConnectionsForHost(Object partitionKey) {
        return (Semaphore)this.freeChannelsPerHost.computeIfAbsent(partitionKey, this.semaphoreComputer);
    }

    private boolean tryAcquirePerHost(Object partitionKey) {
        return !this.maxConnectionsPerHostEnabled || this.getFreeConnectionsForHost(partitionKey).tryAcquire();
    }

    public void preemptChannel(Object partitionKey) throws IOException {
        if (!this.channelPool.isOpen()) {
            throw this.poolAlreadyClosed;
        }
        if (!this.tryAcquireGlobal()) {
            throw this.tooManyConnections;
        }
        if (!this.tryAcquirePerHost(partitionKey)) {
            if (this.maxTotalConnectionsEnabled) {
                this.freeChannels.release();
            }
            throw this.tooManyConnectionsPerHost;
        }
    }

    private void doClose() {
        this.channelPool.destroy();
        this.openChannels.close();
        for (Channel channel : this.openChannels) {
            Object attribute = Channels.getAttribute(channel);
            if (!(attribute instanceof NettyResponseFuture)) continue;
            NettyResponseFuture nettyFuture = (NettyResponseFuture)attribute;
            nettyFuture.cancelTimeouts();
        }
    }

    public void close() {
        if (this.allowReleaseEventLoopGroup) {
            Future whenEventLoopGroupClosed = this.eventLoopGroup.shutdownGracefully((long)this.config.getShutdownQuietPeriod(), (long)this.config.getShutdownTimeout(), TimeUnit.MILLISECONDS);
            whenEventLoopGroupClosed.addListener(new GenericFutureListener<Future<?>>(){

                public void operationComplete(Future<?> future) throws Exception {
                    ChannelManager.this.doClose();
                }
            });
        } else {
            this.doClose();
        }
    }

    public void closeChannel(Channel channel) {
        LOGGER.debug("Closing Channel {} ", (Object)channel);
        this.removeAll(channel);
        Channels.setDiscard(channel);
        Channels.silentlyCloseChannel(channel);
        this.openChannels.remove((Object)channel);
    }

    public void abortChannelPreemption(Object partitionKey) {
        if (this.maxTotalConnectionsEnabled) {
            this.freeChannels.release();
        }
        if (this.maxConnectionsPerHostEnabled) {
            this.getFreeConnectionsForHost(partitionKey).release();
        }
    }

    public void registerOpenChannel(Channel channel, Object partitionKey) {
        this.openChannels.add((Object)channel);
        if (this.maxConnectionsPerHostEnabled) {
            this.channelId2PartitionKey.put((Object)channel, partitionKey);
        }
    }

    private HttpClientCodec newHttpClientCodec() {
        return new HttpClientCodec(this.config.getHttpClientCodecMaxInitialLineLength(), this.config.getHttpClientCodecMaxHeaderSize(), this.config.getHttpClientCodecMaxChunkSize(), false);
    }

    private SslHandler createSslHandler(String peerHost, int peerPort) throws GeneralSecurityException {
        SSLEngine sslEngine = this.sslEngineFactory.newSSLEngine(peerHost, peerPort);
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.handshakeTimeout > 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeout);
        }
        return sslHandler;
    }

    public static boolean isSslHandlerConfigured(ChannelPipeline pipeline) {
        return pipeline.get(SSL_HANDLER) != null;
    }

    public void upgradeProtocol(ChannelPipeline pipeline, Uri requestUri) throws GeneralSecurityException {
        if (pipeline.get(HTTP_HANDLER) != null) {
            pipeline.remove(HTTP_HANDLER);
        }
        if (requestUri.isSecured()) {
            if (ChannelManager.isSslHandlerConfigured(pipeline)) {
                pipeline.addAfter(SSL_HANDLER, HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
            } else {
                pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
                pipeline.addFirst(SSL_HANDLER, (ChannelHandler)this.createSslHandler(requestUri.getHost(), requestUri.getExplicitPort()));
            }
        } else {
            pipeline.addFirst(HTTP_HANDLER, (ChannelHandler)this.newHttpClientCodec());
        }
        if (requestUri.isWebSocket()) {
            pipeline.addAfter(HTTP_PROCESSOR, WS_PROCESSOR, (ChannelHandler)this.wsProcessor);
            pipeline.remove(HTTP_PROCESSOR);
        }
    }

    public SslHandler addSslHandler(ChannelPipeline pipeline, Uri uri, String virtualHost) throws GeneralSecurityException {
        int peerPort;
        String peerHost;
        if (virtualHost != null) {
            int i = virtualHost.indexOf(58);
            if (i == -1) {
                peerHost = virtualHost;
                peerPort = uri.getSchemeDefaultPort();
            } else {
                peerHost = virtualHost.substring(0, i);
                peerPort = Integer.valueOf(virtualHost.substring(i + 1));
            }
        } else {
            peerHost = uri.getHost();
            peerPort = uri.getExplicitPort();
        }
        SslHandler sslHandler = this.createSslHandler(peerHost, peerPort);
        pipeline.addFirst(SSL_HANDLER, (ChannelHandler)sslHandler);
        return sslHandler;
    }

    public void verifyChannelPipeline(ChannelPipeline pipeline, Uri uri, String virtualHost) throws GeneralSecurityException {
        boolean sslHandlerConfigured = ChannelManager.isSslHandlerConfigured(pipeline);
        if (uri.isSecured()) {
            if (!sslHandlerConfigured) {
                this.addSslHandler(pipeline, uri, virtualHost);
            }
        } else if (sslHandlerConfigured) {
            pipeline.remove(SSL_HANDLER);
        }
    }

    public Bootstrap getBootstrap(Uri uri, ProxyServer proxy) {
        return uri.isWebSocket() && proxy == null ? this.wsBootstrap : this.httpBootstrap;
    }

    public void upgradePipelineForWebSockets(ChannelPipeline pipeline) {
        pipeline.addAfter(HTTP_HANDLER, WS_ENCODER_HANDLER, (ChannelHandler)new WebSocket08FrameEncoder(true));
        pipeline.remove(HTTP_HANDLER);
        pipeline.addBefore(WS_PROCESSOR, WS_DECODER_HANDLER, (ChannelHandler)new WebSocket08FrameDecoder(false, false, this.config.getWebSocketMaxFrameSize()));
        pipeline.addAfter(WS_DECODER_HANDLER, WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(this.config.getWebSocketMaxBufferSize()));
    }

    public final Callback newDrainCallback(NettyResponseFuture<?> future, final Channel channel, final boolean keepAlive, final Object partitionKey) {
        return new Callback(future){

            @Override
            public void call() {
                ChannelManager.this.tryToOfferChannelToPool(channel, this.future.getAsyncHandler(), keepAlive, partitionKey);
            }
        };
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future) {
        this.drainChannelAndOffer(channel, future, future.isKeepAlive(), future.getPartitionKey());
    }

    public void drainChannelAndOffer(Channel channel, NettyResponseFuture<?> future, boolean keepAlive, Object partitionKey) {
        Channels.setAttribute(channel, this.newDrainCallback(future, channel, keepAlive, partitionKey));
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }
}

