/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;

public final class ByteArrayBodyGenerator
implements BodyGenerator {
    private final byte[] bytes;

    public ByteArrayBodyGenerator(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public Body createBody() {
        return new ByteBody();
    }

    protected final class ByteBody
    implements Body {
        private boolean eof = false;
        private int lastPosition = 0;

        protected ByteBody() {
        }

        @Override
        public long getContentLength() {
            return ByteArrayBodyGenerator.this.bytes.length;
        }

        @Override
        public Body.BodyState read(ByteBuffer byteBuffer) throws IOException {
            if (this.eof) {
                return Body.BodyState.Stop;
            }
            int remaining = ByteArrayBodyGenerator.this.bytes.length - this.lastPosition;
            if (remaining <= byteBuffer.capacity()) {
                byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, remaining);
                this.eof = true;
            } else {
                byteBuffer.put(ByteArrayBodyGenerator.this.bytes, this.lastPosition, byteBuffer.capacity());
                this.lastPosition += byteBuffer.capacity();
            }
            return Body.BodyState.Continue;
        }

        @Override
        public void close() throws IOException {
            this.lastPosition = 0;
            this.eof = false;
        }
    }
}

