/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.request.body.multipart.MultipartUtils;
import org.asynchttpclient.request.body.multipart.OutputStreamPartVisitor;
import org.asynchttpclient.request.body.multipart.PartBase;
import org.asynchttpclient.util.Assertions;

public class StringPart
extends PartBase {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private final byte[] content;
    private final String value;

    private static Charset charsetOrDefault(Charset charset) {
        return charset == null ? DEFAULT_CHARSET : charset;
    }

    private static String contentTypeOrDefault(String contentType) {
        return contentType == null ? DEFAULT_CONTENT_TYPE : contentType;
    }

    private static String transferEncodingOrDefault(String transferEncoding) {
        return transferEncoding == null ? DEFAULT_TRANSFER_ENCODING : transferEncoding;
    }

    public StringPart(String name, String value) {
        this(name, value, null);
    }

    public StringPart(String name, String value, String contentType) {
        this(name, value, contentType, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset) {
        this(name, value, contentType, charset, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset, String contentId) {
        this(name, value, contentType, charset, contentId, null);
    }

    public StringPart(String name, String value, String contentType, Charset charset, String contentId, String transferEncoding) {
        super(name, StringPart.contentTypeOrDefault(contentType), StringPart.charsetOrDefault(charset), contentId, StringPart.transferEncodingOrDefault(transferEncoding));
        Assertions.assertNotNull(value, "value");
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.content = value.getBytes(this.getCharset());
        this.value = value;
    }

    @Override
    protected long getDataLength() {
        return this.content.length;
    }

    public byte[] getBytes(byte[] boundary) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamPartVisitor visitor = new OutputStreamPartVisitor(os);
        this.visitStart(visitor, boundary);
        this.visitDispositionHeader(visitor);
        this.visitContentTypeHeader(visitor);
        this.visitTransferEncodingHeader(visitor);
        this.visitContentIdHeader(visitor);
        this.visitCustomHeaders(visitor);
        this.visitEndOfHeaders(visitor);
        os.write(this.content);
        this.visitEnd(visitor);
        return os.toByteArray();
    }

    @Override
    public long write(WritableByteChannel target, byte[] boundary) throws IOException {
        return MultipartUtils.writeBytesToChannel(target, this.getBytes(boundary));
    }

    public String getValue() {
        return this.value;
    }
}

