/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.util.Timer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import org.asynchttpclient.Realm;
import org.asynchttpclient.channel.SSLEngineFactory;
import org.asynchttpclient.channel.pool.KeepAliveStrategy;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.filter.ResponseFilter;
import org.asynchttpclient.netty.EagerNettyResponseBodyPart;
import org.asynchttpclient.netty.LazyNettyResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseBodyPart;
import org.asynchttpclient.netty.channel.pool.ChannelPool;
import org.asynchttpclient.netty.ws.NettyWebSocket;
import org.asynchttpclient.proxy.ProxyServerSelector;

public interface AsyncHttpClientConfig {
    public String getAhcVersion();

    public String getThreadPoolName();

    public int getMaxConnections();

    public int getMaxConnectionsPerHost();

    public int getConnectTimeout();

    public int getWebSocketTimeout();

    public int getReadTimeout();

    public int getPooledConnectionIdleTimeout();

    public int getRequestTimeout();

    public boolean isFollowRedirect();

    public int getMaxRedirects();

    public boolean isKeepAlive();

    public String getUserAgent();

    public boolean isCompressionEnforced();

    public ThreadFactory getThreadFactory();

    public ProxyServerSelector getProxyServerSelector();

    public SSLContext getSslContext();

    public Realm getRealm();

    public List<RequestFilter> getRequestFilters();

    public List<ResponseFilter> getResponseFilters();

    public List<IOExceptionFilter> getIoExceptionFilters();

    public int getMaxRequestRetry();

    public boolean isDisableUrlEncodingForBoundRequests();

    public boolean isStrict302Handling();

    public int getConnectionTtl();

    public boolean isAcceptAnyCertificate();

    public String[] getEnabledProtocols();

    public String[] getEnabledCipherSuites();

    public Integer getSslSessionCacheSize();

    public Integer getSslSessionTimeout();

    public int getHttpClientCodecMaxInitialLineLength();

    public int getHttpClientCodecMaxHeaderSize();

    public int getHttpClientCodecMaxChunkSize();

    public boolean isDisableZeroCopy();

    public int getHandshakeTimeout();

    public SSLEngineFactory getSslEngineFactory();

    public int getChunkedFileChunkSize();

    public int getWebSocketMaxBufferSize();

    public int getWebSocketMaxFrameSize();

    public boolean isKeepEncodingHeader();

    public int getShutdownQuietPeriod();

    public int getShutdownTimeout();

    public Map<ChannelOption<Object>, Object> getChannelOptions();

    public EventLoopGroup getEventLoopGroup();

    public boolean isPreferNative();

    public AdditionalPipelineInitializer getHttpAdditionalPipelineInitializer();

    public AdditionalPipelineInitializer getWsAdditionalPipelineInitializer();

    public ResponseBodyPartFactory getResponseBodyPartFactory();

    public ChannelPool getChannelPool();

    public Timer getNettyTimer();

    public NettyWebSocketFactory getNettyWebSocketFactory();

    public KeepAliveStrategy getKeepAliveStrategy();

    public static interface NettyWebSocketFactory {
        public NettyWebSocket newNettyWebSocket(Channel var1, AsyncHttpClientConfig var2);

        public static enum DefaultNettyWebSocketFactory implements NettyWebSocketFactory
        {
            INSTANCE;


            @Override
            public NettyWebSocket newNettyWebSocket(Channel channel, AsyncHttpClientConfig config) {
                return new NettyWebSocket(channel, config);
            }
        }
    }

    public static enum ResponseBodyPartFactory {
        EAGER{

            @Override
            public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new EagerNettyResponseBodyPart(buf, last);
            }
        }
        ,
        LAZY{

            @Override
            public NettyResponseBodyPart newResponseBodyPart(ByteBuf buf, boolean last) {
                return new LazyNettyResponseBodyPart(buf, last);
            }
        };


        public abstract NettyResponseBodyPart newResponseBodyPart(ByteBuf var1, boolean var2);
    }

    public static interface AdditionalPipelineInitializer {
        public void initPipeline(ChannelPipeline var1) throws Exception;
    }
}

