/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.multipart.part;

import java.nio.ByteBuffer;

public interface PartVisitor {
    public void withBytes(byte[] var1);

    public void withByte(byte var1);

    public static class ByteBufferVisitor
    implements PartVisitor {
        private final ByteBuffer target;

        public ByteBufferVisitor(ByteBuffer target) {
            this.target = target;
        }

        @Override
        public void withBytes(byte[] bytes) {
            this.target.put(bytes);
        }

        @Override
        public void withByte(byte b) {
            this.target.put(b);
        }
    }

    public static class CounterPartVisitor
    implements PartVisitor {
        private long count = 0L;

        @Override
        public void withBytes(byte[] bytes) {
            this.count += (long)bytes.length;
        }

        @Override
        public void withByte(byte b) {
            ++this.count;
        }

        public long getCount() {
            return this.count;
        }
    }
}

