/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.channel.pool;

import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;

public interface ConnectionPoolPartitioning {
    public Object getPartitionKey(Uri var1, String var2, ProxyServer var3);

    public static enum PerHostConnectionPoolPartitioning implements ConnectionPoolPartitioning
    {
        INSTANCE;


        @Override
        public Object getPartitionKey(Uri uri, String virtualHost, ProxyServer proxyServer) {
            String targetHostBaseUrl;
            String string = targetHostBaseUrl = virtualHost != null ? virtualHost : HttpUtils.getBaseUrl(uri);
            if (proxyServer != null) {
                return uri.isSecured() ? new ProxyPartitionKey(proxyServer.getHost(), proxyServer.getSecuredPort(), true, targetHostBaseUrl) : new ProxyPartitionKey(proxyServer.getHost(), proxyServer.getPort(), false, targetHostBaseUrl);
            }
            return targetHostBaseUrl;
        }
    }

    public static class ProxyPartitionKey {
        private final String proxyHost;
        private final int proxyPort;
        private final boolean secured;
        private final String targetHostBaseUrl;

        public ProxyPartitionKey(String proxyHost, int proxyPort, boolean secured, String targetHostBaseUrl) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.secured = secured;
            this.targetHostBaseUrl = targetHostBaseUrl;
        }

        public String toString() {
            return "ProxyPartitionKey(proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", secured=" + this.secured + ", targetHostBaseUrl=" + this.targetHostBaseUrl;
        }
    }
}

