/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import java.net.SocketAddress;
import java.util.List;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.NettyResponse;
import org.asynchttpclient.uri.Uri;

public class NettyResponseStatus
extends HttpResponseStatus {
    private final HttpResponse response;
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;

    public NettyResponseStatus(Uri uri, AsyncHttpClientConfig config, HttpResponse response, Channel channel) {
        super(uri, config);
        this.response = response;
        if (channel != null) {
            this.remoteAddress = channel.remoteAddress();
            this.localAddress = channel.localAddress();
        } else {
            this.remoteAddress = null;
            this.localAddress = null;
        }
    }

    @Override
    public Response prepareResponse(HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        return new NettyResponse(this, headers, bodyParts);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus().code();
    }

    @Override
    public String getStatusText() {
        return this.response.getStatus().reasonPhrase();
    }

    @Override
    public String getProtocolName() {
        return this.response.getProtocolVersion().protocolName();
    }

    @Override
    public int getProtocolMajorVersion() {
        return this.response.getProtocolVersion().majorVersion();
    }

    @Override
    public int getProtocolMinorVersion() {
        return this.response.getProtocolVersion().minorVersion();
    }

    @Override
    public String getProtocolText() {
        return this.response.getProtocolVersion().text();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

