/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.channel.NameResolution;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;

public class NettyChannelConnector {
    private final AsyncHandlerExtensions asyncHandlerExtensions;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress[] remoteAddresses;
    private volatile int i = 0;

    public NettyChannelConnector(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) throws UnknownHostException {
        NameResolution[] resolutions;
        this.asyncHandlerExtensions = asyncHandler instanceof AsyncHandlerExtensions ? (AsyncHandlerExtensions)((Object)asyncHandler) : null;
        Uri uri = request.getUri();
        int port = uri.getExplicitPort();
        if (request.getAddress() != null) {
            resolutions = new NameResolution[]{new NameResolution(request.getAddress())};
        } else if (proxy != null && !proxy.isIgnoredForHost(uri.getHost())) {
            resolutions = request.getNameResolver().resolve(proxy.getHost());
            port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
        } else {
            resolutions = request.getNameResolver().resolve(uri.getHost());
        }
        if (this.asyncHandlerExtensions != null) {
            this.asyncHandlerExtensions.onDnsResolved(resolutions);
        }
        this.remoteAddresses = new InetSocketAddress[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            this.remoteAddresses[i] = new InetSocketAddress(resolutions[i].address, port);
        }
        this.localAddress = request.getLocalAddress() != null ? new InetSocketAddress(request.getLocalAddress(), 0) : null;
    }

    private boolean pickNextRemoteAddress() {
        ++this.i;
        return this.i < this.remoteAddresses.length;
    }

    public void connect(final Bootstrap bootstrap, final ChannelFutureListener listener) throws UnknownHostException {
        final InetSocketAddress remoteAddress = this.remoteAddresses[this.i];
        ChannelFuture future = this.localAddress != null ? bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)this.localAddress) : bootstrap.connect((SocketAddress)remoteAddress);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean retry = false;
                if (future.isSuccess()) {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionSuccess(future.channel(), remoteAddress.getAddress());
                    }
                } else {
                    if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                        NettyChannelConnector.this.asyncHandlerExtensions.onConnectionFailure(remoteAddress.getAddress());
                    }
                    retry = NettyChannelConnector.this.pickNextRemoteAddress();
                }
                if (retry) {
                    NettyChannelConnector.this.connect(bootstrap, listener);
                } else {
                    listener.operationComplete((Future)future);
                }
            }
        });
    }
}

