/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.util;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.UTFDataFormatException;

public class Utf8Reader {
    private static int SMALL_BUFFER_SIZE = 4096;
    private static final IndexOutOfBoundsException STRING_DECODER_INDEX_OUT_OF_BOUNDS_EXCEPTION = new IndexOutOfBoundsException("String decoder index out of bounds");
    private static final FastThreadLocal<char[]> CACHED_CHAR_BUFFERS = new FastThreadLocal<char[]>(){

        protected char[] initialValue() throws Exception {
            return new char[SMALL_BUFFER_SIZE];
        }
    };

    public static String readUtf8(ByteBuf buf, int utflen) throws UTFDataFormatException, IndexOutOfBoundsException {
        boolean small = utflen <= SMALL_BUFFER_SIZE;
        char[] chararr = small ? (char[])CACHED_CHAR_BUFFERS.get() : new char[utflen];
        int chararr_count = 0;
        if (buf.readableBytes() > utflen) {
            throw STRING_DECODER_INDEX_OUT_OF_BOUNDS_EXCEPTION;
        }
        if (buf instanceof AbstractByteBuf) {
            int char1;
            int count;
            AbstractByteBuf b = (AbstractByteBuf)buf;
            int readerIndex = buf.readerIndex();
            for (count = 0; count < utflen && (char1 = b.getByte(readerIndex + count) & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)char1;
            }
            block6: while (count < utflen) {
                char1 = b.getByte(readerIndex + count) & 0xFF;
                switch (char1 >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        chararr[chararr_count++] = (char)char1;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = b.getByte(readerIndex + count - 1);
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + count);
                        }
                        chararr[chararr_count++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = b.getByte(readerIndex + count - 2);
                        byte char3 = b.getByte(readerIndex + count - 1);
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                        }
                        chararr[chararr_count++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + count);
            }
            buf.readerIndex(buf.readerIndex() + count);
            return new String(chararr, 0, chararr_count);
        }
        byte[] b = new byte[utflen];
        buf.readBytes(b);
        return new String(b);
    }
}

