/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.future;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.future.RunnableExecutorPair;

public abstract class AbstractListenableFuture<V>
implements ListenableFuture<V> {
    private static final RunnableExecutorPair executedMarker = new RunnableExecutorPair();
    private volatile RunnableExecutorPair executionList;
    private static final AtomicReferenceFieldUpdater<AbstractListenableFuture, RunnableExecutorPair> executionListField = AtomicReferenceFieldUpdater.newUpdater(AbstractListenableFuture.class, RunnableExecutorPair.class, "executionList");

    @Override
    public ListenableFuture<V> addListener(Runnable listener, Executor exec) {
        RunnableExecutorPair pair;
        RunnableExecutorPair executionListLocal;
        do {
            if ((executionListLocal = this.executionList) != executedMarker) continue;
            RunnableExecutorPair.executeListener(listener, exec);
            return this;
        } while (!executionListField.compareAndSet(this, executionListLocal, pair = new RunnableExecutorPair(listener, exec, executionListLocal)));
        return this;
    }

    protected void runListeners() {
        RunnableExecutorPair execution = executionListField.getAndSet(this, executedMarker);
        if (execution == executedMarker) {
            return;
        }
        RunnableExecutorPair reversedList = RunnableExecutorPair.reverseList(execution);
        while (reversedList != null) {
            RunnableExecutorPair.executeListener(reversedList.runnable, reversedList.executor);
            reversedList = reversedList.next;
        }
    }
}

