/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.Timer;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.AsyncHttpClientState;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.exception.PoolAlreadyClosedException;
import org.asynchttpclient.exception.RemotelyClosedException;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.IOExceptionFilter;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.TransferCompletionHandler;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.OnLastHttpContentCallback;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.channel.NettyConnectListener;
import org.asynchttpclient.netty.request.NettyChannelConnector;
import org.asynchttpclient.netty.request.NettyRequest;
import org.asynchttpclient.netty.request.NettyRequestFactory;
import org.asynchttpclient.netty.request.WriteCompleteListener;
import org.asynchttpclient.netty.request.WriteProgressListener;
import org.asynchttpclient.netty.timeout.TimeoutsHolder;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.resolver.RequestHostnameResolver;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Assertions;
import org.asynchttpclient.util.AuthenticatorUtils;
import org.asynchttpclient.util.HttpConstants;
import org.asynchttpclient.util.MiscUtils;
import org.asynchttpclient.util.ProxyUtils;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyRequestSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyRequestSender.class);
    private final AsyncHttpClientConfig config;
    private final ChannelManager channelManager;
    private final ConnectionSemaphore connectionSemaphore;
    private final Timer nettyTimer;
    private final AsyncHttpClientState clientState;
    private final NettyRequestFactory requestFactory;

    public NettyRequestSender(AsyncHttpClientConfig config, ChannelManager channelManager, ConnectionSemaphore connectionSemaphore, Timer nettyTimer, AsyncHttpClientState clientState) {
        this.config = config;
        this.channelManager = channelManager;
        this.connectionSemaphore = connectionSemaphore;
        this.nettyTimer = nettyTimer;
        this.clientState = clientState;
        this.requestFactory = new NettyRequestFactory(config);
    }

    public <T> ListenableFuture<T> sendRequest(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean performingNextRequest) {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        this.validateWebSocketRequest(request, asyncHandler);
        ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, request);
        if (proxyServer != null && (request.getUri().isSecured() || request.getUri().isWebSocket()) && !this.isConnectDone(request, future)) {
            if (future != null && future.isConnectAllowed()) {
                return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, performingNextRequest, proxyServer, true);
            }
            return this.sendRequestThroughSslProxy(request, asyncHandler, future, performingNextRequest, proxyServer);
        }
        return this.sendRequestWithCertainForceConnect(request, asyncHandler, future, performingNextRequest, proxyServer, false);
    }

    private boolean isConnectDone(Request request, NettyResponseFuture<?> future) {
        return future != null && future.getNettyRequest() != null && future.getNettyRequest().getHttpRequest().method() == HttpMethod.CONNECT && !request.getMethod().equals(HttpConstants.Methods.CONNECT);
    }

    private <T> ListenableFuture<T> sendRequestWithCertainForceConnect(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean performingNextRequest, ProxyServer proxyServer, boolean forceConnect) {
        NettyResponseFuture<T> newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, forceConnect);
        Channel channel = this.getOpenChannel(future, request, proxyServer, asyncHandler);
        if (Channels.isChannelValid(channel)) {
            return this.sendRequestWithOpenChannel(request, proxyServer, newFuture, asyncHandler, channel);
        }
        return this.sendRequestWithNewChannel(request, proxyServer, newFuture, asyncHandler, performingNextRequest);
    }

    private <T> ListenableFuture<T> sendRequestThroughSslProxy(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, boolean performingNextRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> newFuture = null;
        int i = 0;
        if (i < 3) {
            Channel channel = this.getOpenChannel(future, request, proxyServer, asyncHandler);
            if (Channels.isChannelValid(channel) && newFuture == null) {
                newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, false);
            }
            if (Channels.isChannelValid(channel)) {
                return this.sendRequestWithOpenChannel(request, proxyServer, newFuture, asyncHandler, channel);
            }
        }
        newFuture = this.newNettyRequestAndResponseFuture(request, asyncHandler, future, proxyServer, true);
        return this.sendRequestWithNewChannel(request, proxyServer, newFuture, asyncHandler, performingNextRequest);
    }

    private <T> NettyResponseFuture<T> newNettyRequestAndResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> originalFuture, ProxyServer proxy, boolean forceConnect) {
        Realm realm = null;
        if (originalFuture != null) {
            realm = originalFuture.getRealm();
        } else {
            realm = request.getRealm();
            if (realm == null) {
                realm = this.config.getRealm();
            }
        }
        Realm proxyRealm = null;
        if (originalFuture != null) {
            proxyRealm = originalFuture.getProxyRealm();
        } else if (proxy != null) {
            proxyRealm = proxy.getRealm();
        }
        NettyRequest nettyRequest = this.requestFactory.newNettyRequest(request, forceConnect, proxy, realm, proxyRealm);
        if (originalFuture == null) {
            NettyResponseFuture<T> future = this.newNettyResponseFuture(request, asyncHandler, nettyRequest, proxy);
            future.setRealm(realm);
            future.setProxyRealm(proxyRealm);
            return future;
        }
        originalFuture.setNettyRequest(nettyRequest);
        originalFuture.setCurrentRequest(request);
        return originalFuture;
    }

    private Channel getOpenChannel(NettyResponseFuture<?> future, Request request, ProxyServer proxyServer, AsyncHandler<?> asyncHandler) {
        if (future != null && future.isReuseChannel() && Channels.isChannelValid(future.channel())) {
            return future.channel();
        }
        return this.pollPooledChannel(request, proxyServer, asyncHandler);
    }

    private <T> ListenableFuture<T> sendRequestWithOpenChannel(Request request, ProxyServer proxy, NettyResponseFuture<T> future, AsyncHandler<T> asyncHandler, Channel channel) {
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionPooled(channel);
        }
        TimeoutsHolder timeoutsHolder = this.scheduleRequestTimeout(future);
        timeoutsHolder.initRemoteAddress((InetSocketAddress)channel.remoteAddress());
        future.setChannelState(ChannelState.POOLED);
        future.attachChannel(channel, false);
        if (LOGGER.isDebugEnabled()) {
            HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
            LOGGER.debug("Using open Channel {} for {} '{}'", new Object[]{channel, httpRequest.method(), httpRequest.uri()});
        }
        Channels.setAttribute(channel, future);
        if (Channels.isChannelValid(channel)) {
            this.writeRequest(future, channel);
        } else {
            this.handleUnexpectedClosedChannel(channel, future);
        }
        return future;
    }

    private <T> ListenableFuture<T> sendRequestWithNewChannel(final Request request, ProxyServer proxy, final NettyResponseFuture<T> future, final AsyncHandler<T> asyncHandler, boolean performingNextRequest) {
        HttpHeaders headers = future.getNettyRequest().getHttpRequest().headers();
        Realm realm = future.getRealm();
        Realm proxyRealm = future.getProxyRealm();
        this.requestFactory.addAuthorizationHeader(headers, AuthenticatorUtils.perConnectionAuthorizationHeader(request, proxy, realm));
        this.requestFactory.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perConnectionProxyAuthorizationHeader(request, proxyRealm));
        future.setInAuth(realm != null && realm.isUsePreemptiveAuth() && realm.getScheme() != Realm.AuthScheme.NTLM);
        future.setInProxyAuth(proxyRealm != null && proxyRealm.isUsePreemptiveAuth() && proxyRealm.getScheme() != Realm.AuthScheme.NTLM);
        final Bootstrap bootstrap = this.channelManager.getBootstrap(request.getUri(), proxy);
        final Object partitionKey = future.getPartitionKey();
        try {
            if (!this.channelManager.isOpen()) {
                throw PoolAlreadyClosedException.INSTANCE;
            }
            future.acquirePartitionLockLazily();
        }
        catch (Throwable t) {
            this.abort(null, future, MiscUtils.getCause(t));
            return future;
        }
        this.scheduleRequestTimeout(future);
        RequestHostnameResolver.INSTANCE.resolve(request, proxy, asyncHandler).addListener((GenericFutureListener)new SimpleFutureListener<List<InetSocketAddress>>(){

            @Override
            protected void onSuccess(List<InetSocketAddress> addresses) {
                NettyConnectListener connectListener = new NettyConnectListener(future, NettyRequestSender.this, NettyRequestSender.this.channelManager, NettyRequestSender.this.connectionSemaphore, partitionKey);
                NettyChannelConnector connector = new NettyChannelConnector(request.getLocalAddress(), addresses, asyncHandler, NettyRequestSender.this.clientState, NettyRequestSender.this.config);
                if (!future.isDone()) {
                    connector.connect(bootstrap, connectListener);
                }
            }

            @Override
            protected void onFailure(Throwable cause) {
                NettyRequestSender.this.abort(null, future, MiscUtils.getCause(cause));
            }
        });
        return future;
    }

    private <T> NettyResponseFuture<T> newNettyResponseFuture(Request request, AsyncHandler<T> asyncHandler, NettyRequest nettyRequest, ProxyServer proxyServer) {
        NettyResponseFuture<T> future = new NettyResponseFuture<T>(request, asyncHandler, nettyRequest, this.config.getMaxRequestRetry(), request.getChannelPoolPartitioning(), this.connectionSemaphore, proxyServer);
        String expectHeader = request.getHeaders().get((CharSequence)HttpHeaderNames.EXPECT);
        if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase((CharSequence)expectHeader)) {
            future.setDontWriteBodyBecauseExpectContinue(true);
        }
        return future;
    }

    public <T> void writeRequest(NettyResponseFuture<T> future, Channel channel) {
        NettyRequest nettyRequest = future.getNettyRequest();
        HttpRequest httpRequest = nettyRequest.getHttpRequest();
        AsyncHandler<T> handler = future.getAsyncHandler();
        if (!Channels.isChannelValid(channel)) {
            return;
        }
        try {
            boolean writeBody;
            if (handler instanceof TransferCompletionHandler) {
                this.configureTransferAdapter(handler, httpRequest);
            }
            boolean bl = writeBody = !future.isDontWriteBodyBecauseExpectContinue() && httpRequest.method() != HttpMethod.CONNECT && nettyRequest.getBody() != null;
            if (!future.isHeadersAlreadyWrittenOnContinue()) {
                if (handler instanceof AsyncHandlerExtensions) {
                    ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(handler)).onRequestSend(nettyRequest);
                }
                if (writeBody) {
                    ChannelProgressivePromise promise = channel.newProgressivePromise();
                    ChannelFuture f = channel.write((Object)httpRequest, (ChannelPromise)promise);
                    f.addListener((GenericFutureListener)new WriteProgressListener(future, true, 0L));
                } else {
                    ChannelPromise promise = channel.newPromise();
                    ChannelFuture f = channel.writeAndFlush((Object)httpRequest, promise);
                    f.addListener((GenericFutureListener)new WriteCompleteListener(future));
                }
            }
            if (writeBody) {
                nettyRequest.getBody().write(channel, future);
            }
            if (Channels.isChannelValid(channel)) {
                this.scheduleReadTimeout(future);
            }
        }
        catch (Exception e) {
            LOGGER.error("Can't write request", (Throwable)e);
            this.abort(channel, future, e);
        }
    }

    private void configureTransferAdapter(AsyncHandler<?> handler, HttpRequest httpRequest) {
        HttpHeaders h = new DefaultHttpHeaders(false).set(httpRequest.headers());
        ((TransferCompletionHandler)TransferCompletionHandler.class.cast(handler)).headers(h);
    }

    private TimeoutsHolder scheduleRequestTimeout(NettyResponseFuture<?> nettyResponseFuture) {
        nettyResponseFuture.touch();
        TimeoutsHolder timeoutsHolder = new TimeoutsHolder(this.nettyTimer, nettyResponseFuture, this, this.config);
        nettyResponseFuture.setTimeoutsHolder(timeoutsHolder);
        return timeoutsHolder;
    }

    private void scheduleReadTimeout(NettyResponseFuture<?> nettyResponseFuture) {
        TimeoutsHolder timeoutsHolder = nettyResponseFuture.getTimeoutsHolder();
        if (timeoutsHolder != null) {
            nettyResponseFuture.touch();
            timeoutsHolder.startReadTimeout();
        }
    }

    public void abort(Channel channel, NettyResponseFuture<?> future, Throwable t) {
        if (channel != null) {
            this.channelManager.closeChannel(channel);
        }
        if (!future.isDone()) {
            future.setChannelState(ChannelState.CLOSED);
            LOGGER.debug("Aborting Future {}\n", future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    public void handleUnexpectedClosedChannel(Channel channel, NettyResponseFuture<?> future) {
        if (Channels.getInactiveToken(channel)) {
            if (future.isDone()) {
                this.channelManager.closeChannel(channel);
            } else if (future.incrementRetryAndCheck() && this.retry(future)) {
                future.pendingException = null;
            } else {
                this.abort(channel, future, future.pendingException != null ? future.pendingException : RemotelyClosedException.INSTANCE);
            }
        }
    }

    public boolean retry(NettyResponseFuture<?> future) {
        if (this.isClosed()) {
            return false;
        }
        if (future.isReplayPossible()) {
            future.setChannelState(ChannelState.RECONNECTED);
            LOGGER.debug("Trying to recover request {}\n", (Object)future.getNettyRequest().getHttpRequest());
            if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
                ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
            }
            try {
                this.sendNextRequest(future.getCurrentRequest(), future);
                return true;
            }
            catch (Exception e) {
                this.abort(future.channel(), future, e);
                return false;
            }
        }
        LOGGER.debug("Unable to recover future {}\n", future);
        return false;
    }

    public boolean applyIoExceptionFiltersAndReplayRequest(NettyResponseFuture<?> future, IOException e, Channel channel) {
        boolean replayed = false;
        FilterContext fc = new FilterContext.FilterContextBuilder().asyncHandler(future.getAsyncHandler()).request(future.getCurrentRequest()).ioException(e).build();
        for (IOExceptionFilter asyncFilter : this.config.getIoExceptionFilters()) {
            try {
                fc = asyncFilter.filter(fc);
                Assertions.assertNotNull(fc, "filterContext");
            }
            catch (FilterException efe) {
                this.abort(channel, future, efe);
            }
        }
        if (fc.replayRequest() && future.incrementRetryAndCheck() && future.isReplayPossible()) {
            this.replayRequest(future, fc, channel);
            replayed = true;
        }
        return replayed;
    }

    public <T> void sendNextRequest(Request request, NettyResponseFuture<T> future) {
        this.sendRequest(request, future.getAsyncHandler(), future, true);
    }

    private void validateWebSocketRequest(Request request, AsyncHandler<?> asyncHandler) {
        Uri uri = request.getUri();
        boolean isWs = uri.isWebSocket();
        if (asyncHandler instanceof WebSocketUpgradeHandler) {
            if (!isWs) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but scheme isn't ws or wss: " + uri.getScheme());
            }
            if (!request.getMethod().equals(HttpConstants.Methods.GET) && !request.getMethod().equals(HttpConstants.Methods.CONNECT)) {
                throw new IllegalArgumentException("WebSocketUpgradeHandler but method isn't GET or CONNECT: " + request.getMethod());
            }
        } else if (isWs) {
            throw new IllegalArgumentException("No WebSocketUpgradeHandler but scheme is " + uri.getScheme());
        }
    }

    private Channel pollPooledChannel(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        String virtualHost;
        Uri uri;
        Channel channel;
        if (asyncHandler instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onConnectionPoolAttempt();
        }
        if ((channel = this.channelManager.poll(uri = request.getUri(), virtualHost = request.getVirtualHost(), proxy, request.getChannelPoolPartitioning())) != null) {
            LOGGER.debug("Using pooled Channel '{}' for '{}' to '{}'", new Object[]{channel, request.getMethod(), uri});
        }
        return channel;
    }

    public void replayRequest(NettyResponseFuture<?> future, FilterContext fc, Channel channel) {
        Request newRequest = fc.getRequest();
        future.setAsyncHandler(fc.getAsyncHandler());
        future.setChannelState(ChannelState.NEW);
        future.touch();
        LOGGER.debug("\n\nReplaying Request {}\n for Future {}\n", (Object)newRequest, future);
        if (future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(future.getAsyncHandler())).onRetry();
        }
        this.channelManager.drainChannelAndOffer(channel, future);
        this.sendNextRequest(newRequest, future);
    }

    public boolean isClosed() {
        return this.clientState.isClosed();
    }

    public void drainChannelAndExecuteNextRequest(Channel channel, NettyResponseFuture<?> future, final Request nextRequest) {
        Channels.setAttribute(channel, new OnLastHttpContentCallback(future){

            @Override
            public void call() {
                NettyRequestSender.this.sendNextRequest(nextRequest, this.future);
            }
        });
    }
}

