/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.resolver;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RequestHostnameResolver {
    INSTANCE;

    private static final Logger LOGGER;

    public Future<List<InetSocketAddress>> resolve(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        int port;
        String name;
        AsyncHandlerExtensions asyncHandlerExtensions;
        Uri uri = request.getUri();
        final Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (request.getAddress() != null) {
            List<InetSocketAddress> resolved = Collections.singletonList(new InetSocketAddress(request.getAddress(), uri.getExplicitPort()));
            return promise.setSuccess(resolved);
        }
        AsyncHandlerExtensions asyncHandlerExtensions2 = asyncHandlerExtensions = request.getAddress() == null ? AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler) : null;
        if (proxy != null && !proxy.isIgnoredForHost(uri.getHost())) {
            name = proxy.getHost();
            port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
        } else {
            name = uri.getHost();
            port = uri.getExplicitPort();
        }
        if (asyncHandlerExtensions != null) {
            try {
                asyncHandlerExtensions.onHostnameResolutionAttempt(name);
            }
            catch (Exception e) {
                LOGGER.error("onHostnameResolutionAttempt crashed", (Throwable)e);
                promise.tryFailure((Throwable)e);
                return promise;
            }
        }
        Future whenResolved = request.getNameResolver().resolveAll(name);
        whenResolved.addListener((GenericFutureListener)new SimpleFutureListener<List<InetAddress>>(){

            @Override
            protected void onSuccess(List<InetAddress> value) throws Exception {
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(value.size());
                for (InetAddress a : value) {
                    socketAddresses.add(new InetSocketAddress(a, port));
                }
                if (asyncHandlerExtensions != null) {
                    try {
                        asyncHandlerExtensions.onHostnameResolutionSuccess(name, socketAddresses);
                    }
                    catch (Exception e) {
                        LOGGER.error("onHostnameResolutionSuccess crashed", (Throwable)e);
                        promise.tryFailure((Throwable)e);
                        return;
                    }
                }
                promise.trySuccess(socketAddresses);
            }

            @Override
            protected void onFailure(Throwable t) throws Exception {
                if (asyncHandlerExtensions != null) {
                    try {
                        asyncHandlerExtensions.onHostnameResolutionFailure(name, t);
                    }
                    catch (Exception e) {
                        LOGGER.error("onHostnameResolutionFailure crashed", (Throwable)e);
                        promise.tryFailure((Throwable)e);
                        return;
                    }
                }
                promise.tryFailure(t);
            }
        });
        return promise;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestHostnameResolver.class);
    }
}

